/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.AbstractControlledRpcManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.PessimistTxFailureAfterLockingTest")
@CleanupAfterMethod
public class PessimistTxFailureAfterLockingTest
extends MultipleCacheManagersTest {
    public void testReplyLostWithImplicitLocking() throws Exception {
        this.doTest(false);
    }

    public void testReplyLostWithExplicitLocking() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean explicitLocking) throws Exception {
        MagicKey key = new MagicKey(this.cache(1), this.cache(2));
        this.replaceRpcManagerInCache(this.cache(0));
        boolean failed = false;
        this.tm(0).begin();
        try {
            if (explicitLocking) {
                this.cache(0).getAdvancedCache().lock(new Object[]{key});
            } else {
                this.cache(0).put((Object)key, (Object)"value");
            }
        }
        catch (Exception e) {
            failed = true;
        }
        this.tm(0).rollback();
        AssertJUnit.assertTrue((String)"Expected an exception", (boolean)failed);
        this.assertNoTransactions();
        this.assertNotLocked(this.cache(1), (Object)key);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = PessimistTxFailureAfterLockingTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        builder.clustering().hash().numOwners(2);
        this.createClusteredCaches(3, builder);
    }

    private void replaceRpcManagerInCache(Cache cache) {
        RpcManager rpcManager = TestingUtil.extractComponent(cache, RpcManager.class);
        TestControllerRpcManager testControllerRpcManager = new TestControllerRpcManager(rpcManager);
        TestingUtil.replaceComponent(cache, RpcManager.class, testControllerRpcManager, true);
    }

    private class TestControllerRpcManager
    extends AbstractControlledRpcManager {
        public TestControllerRpcManager(RpcManager realOne) {
            super(realOne);
        }

        @Override
        protected Map<Address, Response> afterInvokeRemotely(ReplicableCommand command, Map<Address, Response> responseMap) {
            if (command instanceof LockControlCommand) {
                throw new TimeoutException("Exception expected!");
            }
            return responseMap;
        }
    }
}

