/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.HashMap;
import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.MainOwnerChangesPessimisticLockTest")
@CleanupAfterMethod
public class MainOwnerChangesPessimisticLockTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 10;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = MainOwnerChangesPessimisticLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.dccc.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true).locking().lockAcquisitionTimeout(1000L).clustering().hash().numOwners(1).numSegments(3).l1().disable().onRehash(false).stateTransfer().fetchInMemoryState(true);
        this.createCluster(this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testLocalLockMigrationTxCommit() throws Exception {
        this.testLockMigration(0, true);
    }

    public void testLocalLockMigrationTxRollback() throws Exception {
        this.testLockMigration(0, false);
    }

    public void testRemoteLockMigrationTxCommit() throws Exception {
        this.testLockMigration(1, true);
    }

    public void testRemoteLockMigrationTxRollback() throws Exception {
        this.testLockMigration(1, false);
    }

    private void testLockMigration(int nodeThatPuts, boolean commit) throws Exception {
        HashMap<Object, Transaction> key2Tx = new HashMap<Object, Transaction>();
        for (int i = 0; i < 10; ++i) {
            Object key = this.getKeyForCache(0);
            if (key2Tx.containsKey(key)) continue;
            this.cache(nodeThatPuts).put(key, key);
            this.tm(nodeThatPuts).begin();
            Transaction tx = this.tm(nodeThatPuts).getTransaction();
            this.advancedCache(nodeThatPuts).lock(new Object[]{key});
            this.tm(nodeThatPuts).suspend();
            key2Tx.put(key, tx);
            this.assertLocked(0, key);
        }
        this.log.trace((Object)"Lock transfer happens here");
        this.addClusterEnabledCacheManager(this.dccc);
        this.waitForClusterToForm();
        Object migratedKey = null;
        Transaction migratedTransaction = null;
        ConsistentHash consistentHash = this.advancedCache(2).getDistributionManager().getConsistentHash();
        for (Object key : key2Tx.keySet()) {
            if (!consistentHash.locatePrimaryOwner(key).equals(this.address(2))) continue;
            migratedKey = key;
            migratedTransaction = (Transaction)key2Tx.get(key);
            this.log.trace((Object)("Migrated key = " + migratedKey));
            this.log.trace((Object)("Migrated transaction = " + ((DummyTransaction)migratedTransaction).getEnlistedResources()));
            break;
        }
        this.log.trace((Object)"Committing all transactions except the migrated one.");
        for (Object key : key2Tx.keySet()) {
            if (key.equals(migratedKey)) continue;
            Transaction tx = (Transaction)key2Tx.get(key);
            this.tm(nodeThatPuts).resume(tx);
            this.tm(nodeThatPuts).commit();
        }
        if (migratedKey == null) {
            this.log.trace((Object)"No key migrated to new owner - test cannot be performed!");
        } else {
            this.tm(nodeThatPuts).resume(migratedTransaction);
            if (commit) {
                this.tm(nodeThatPuts).commit();
            } else {
                this.tm(nodeThatPuts).rollback();
            }
            this.assertNotLocked(this.cache(0), migratedKey);
            this.assertNotLocked(this.cache(1), migratedKey);
            this.assertNotLocked(this.cache(2), migratedKey);
            this.tm(nodeThatPuts).begin();
            this.cache(nodeThatPuts).put(migratedKey, (Object)"someValue");
            this.tm(nodeThatPuts).commit();
        }
        this.log.trace((Object)"Checking the values from caches...");
        for (Object key : key2Tx.keySet()) {
            this.log.tracef("Checking key: %s", key);
            Object expectedValue = key;
            if (key.equals(migratedKey)) {
                expectedValue = "someValue";
            }
            InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
            InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
            InternalCacheEntry d2 = this.advancedCache(2).getDataContainer().get(key);
            int c = 0;
            if (d0 != null && !d0.isExpired()) {
                Assert.assertEquals(expectedValue, (Object)d0.getValue());
                ++c;
            }
            if (d1 != null && !d1.isExpired()) {
                Assert.assertEquals(expectedValue, (Object)d1.getValue());
                ++c;
            }
            if (d2 != null && !d2.isExpired()) {
                Assert.assertEquals(expectedValue, (Object)d2.getValue());
                ++c;
            }
            Assert.assertEquals((long)1L, (long)c);
            Assert.assertEquals(expectedValue, (Object)this.cache(0).get(key));
            Assert.assertEquals(expectedValue, (Object)this.cache(1).get(key));
            Assert.assertEquals(expectedValue, (Object)this.cache(2).get(key));
        }
    }
}

