/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.MinViewIdCalculusTest")
@CleanupAfterMethod
public class MinViewIdCalculusTest
extends MultipleCacheManagersTest {
    private Configuration c;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.c = MinViewIdCalculusTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        this.c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.c.fluent().hash().numOwners(Integer.valueOf(3));
        this.createCluster(this.c, 2);
        this.waitForClusterToForm();
    }

    public void testMinViewId1() throws Exception {
        TransactionTable tt0 = TestingUtil.getTransactionTable(this.cache(0));
        TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        StateTransferManager stateTransferManager0 = TestingUtil.extractComponent(this.cache(0), StateTransferManager.class);
        int viewId = stateTransferManager0.getCacheTopology().getTopologyId();
        Assert.assertEquals((int)tt0.getMinTopologyId(), (int)viewId);
        Assert.assertEquals((int)tt1.getMinTopologyId(), (int)viewId);
        this.addClusterEnabledCacheManager(this.c);
        this.waitForClusterToForm();
        int viewId2 = stateTransferManager0.getCacheTopology().getTopologyId();
        Assert.assertTrue((viewId2 > viewId ? 1 : 0) != 0);
        Assert.assertEquals((int)tt0.getMinTopologyId(), (int)viewId2);
        Assert.assertEquals((int)tt1.getMinTopologyId(), (int)viewId2);
        TransactionTable tt2 = TestingUtil.getTransactionTable(this.cache(1));
        Assert.assertEquals((int)tt2.getMinTopologyId(), (int)viewId2);
    }

    public void testMinViewId2() throws Exception {
        final TransactionTable tt0 = TestingUtil.getTransactionTable(this.cache(0));
        final TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        StateTransferManager stateTransferManager0 = TestingUtil.extractComponent(this.cache(0), StateTransferManager.class);
        int viewId = stateTransferManager0.getCacheTopology().getTopologyId();
        this.tm(1).begin();
        this.cache(1).put(this.getKeyForCache(0), (Object)"v");
        DummyTransaction t = (DummyTransaction)this.tm(1).getTransaction();
        t.runPrepare();
        this.tm(1).suspend();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return MinViewIdCalculusTest.this.checkTxCount(0, 0, 1);
            }
        });
        this.log.trace((Object)"Here is the topology change..");
        this.addClusterEnabledCacheManager(this.c);
        this.waitForClusterToForm();
        final int viewId2 = stateTransferManager0.getCacheTopology().getTopologyId();
        Assert.assertTrue((viewId2 > viewId ? 1 : 0) != 0);
        Assert.assertEquals((int)tt0.getMinTopologyId(), (int)viewId);
        Assert.assertEquals((int)tt1.getMinTopologyId(), (int)viewId);
        this.tm(1).resume((Transaction)t);
        t.runCommitTx();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return tt0.getMinTopologyId() == viewId2 && tt1.getMinTopologyId() == viewId2;
            }
        });
    }
}

