/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.optimistic;

import org.infinispan.config.Configuration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lock.singlelock.AbstractCrashTest;
import org.infinispan.lock.singlelock.AbstractInitiatorCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.InitiatorCrashOptimisticTest")
@CleanupAfterMethod
public class InitiatorCrashOptimisticTest
extends AbstractInitiatorCrashTest {
    public InitiatorCrashOptimisticTest() {
        super(Configuration.CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false);
    }

    public void testInitiatorNodeCrashesBeforePrepare() throws Exception {
        AbstractCrashTest.TxControlInterceptor txControlInterceptor = new AbstractCrashTest.TxControlInterceptor();
        this.advancedCache(1).addInterceptor((CommandInterceptor)txControlInterceptor, 1);
        Object k = this.getKeyForCache(2);
        this.beginAndPrepareTx(k, 1);
        txControlInterceptor.preparedReceived.await();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 1, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.killMember(1);
        assert (this.caches().size() == 2);
        txControlInterceptor.prepareProgress.countDown();
        this.assertNotLocked(k);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return InitiatorCrashOptimisticTest.this.checkTxCount(0, 0, 0) && InitiatorCrashOptimisticTest.this.checkTxCount(1, 0, 0);
            }
        });
    }
}

