/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.optimistic;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractLockOwnerCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.LockOwnerCrashOptimisticTest")
@CleanupAfterMethod
public class LockOwnerCrashOptimisticTest
extends AbstractLockOwnerCrashTest {
    DummyTransaction transaction;

    public LockOwnerCrashOptimisticTest() {
        super(Configuration.CacheMode.DIST_SYNC, LockingMode.OPTIMISTIC, false);
    }

    public void testLockOwnerCrashesBeforePrepare() throws Exception {
        final Object k = this.getKeyForCache(2);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    LockOwnerCrashOptimisticTest.this.tm(1).begin();
                    LockOwnerCrashOptimisticTest.this.cache(1).put(k, (Object)"v");
                    LockOwnerCrashOptimisticTest.this.transaction = (DummyTransaction)LockOwnerCrashOptimisticTest.this.tm(1).getTransaction();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashOptimisticTest.this.checkTxCount(0, 0, 0) && LockOwnerCrashOptimisticTest.this.checkTxCount(1, 1, 0) && LockOwnerCrashOptimisticTest.this.checkTxCount(2, 0, 0);
            }
        });
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(1).resume((Transaction)this.transaction);
        this.tm(1).commit();
        Assert.assertEquals((Object)this.cache(0).get(k), (Object)"v");
        Assert.assertEquals((Object)this.cache(1).get(k), (Object)"v");
        this.assertNotLocked(k);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashOptimisticTest.this.checkTxCount(0, 0, 0) && LockOwnerCrashOptimisticTest.this.checkTxCount(1, 0, 0);
            }
        });
    }

    public void lockOwnerCrasherBetweenPrepareAndCommit() throws Exception {
        final Object k = this.getKeyForCache(2);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    LockOwnerCrashOptimisticTest.this.tm(1).begin();
                    LockOwnerCrashOptimisticTest.this.cache(1).put(k, (Object)"v");
                    LockOwnerCrashOptimisticTest.this.transaction = (DummyTransaction)LockOwnerCrashOptimisticTest.this.tm(1).getTransaction();
                    LockOwnerCrashOptimisticTest.this.transaction.runPrepare();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return LockOwnerCrashOptimisticTest.this.checkTxCount(0, 0, 1) && LockOwnerCrashOptimisticTest.this.checkTxCount(1, 1, 0) && LockOwnerCrashOptimisticTest.this.checkTxCount(2, 0, 1);
            }
        });
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(1).begin();
        this.cache(1).put(k, (Object)"v3");
        try {
            this.tm(1).commit();
            Assert.fail((String)("Exception expected as lock cannot be acquired on k=" + k));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tm(0).begin();
        this.cache(0).put(k, (Object)"v2");
        try {
            this.tm(0).commit();
            Assert.fail((String)("Exception expected as lock cannot be acquired on k=" + k));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tm(1).resume((Transaction)this.transaction);
        this.transaction.runPrepare();
    }
}

