/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.lang.reflect.Method;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.CacheManagerTest")
public class CacheManagerTest
extends AbstractInfinispanTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaultCache() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            assert (cm.getCache().getStatus() == ComponentStatus.RUNNING);
            assert (cm.getCache().getName().equals("___defaultcache"));
            try {
                cm.defineConfiguration("___defaultcache", new ConfigurationBuilder().build());
                assert (false) : "Should fail";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public void testUnstartedCachemanager() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(false)){

            @Override
            public void call() {
                assert (this.cm.getStatus().equals((Object)ComponentStatus.INSTANTIATED));
                assert (!this.cm.getStatus().allowInvocations());
                Cache cache = this.cm.getCache();
                cache.put((Object)"k", (Object)"v");
                assert (cache.get((Object)"k").equals("v"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClashingNames() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            ConfigurationBuilder c = new ConfigurationBuilder();
            Configuration firstDef = cm.defineConfiguration("aCache", c.build());
            Configuration secondDef = cm.defineConfiguration("aCache", c.build());
            assert (firstDef.equals((Object)secondDef));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartAndStop() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache c1 = cm.getCache("cache1");
            Cache c2 = cm.getCache("cache2");
            Cache c3 = cm.getCache("cache3");
            assert (c1.getStatus() == ComponentStatus.RUNNING);
            assert (c2.getStatus() == ComponentStatus.RUNNING);
            assert (c3.getStatus() == ComponentStatus.RUNNING);
            cm.stop();
            assert (c1.getStatus() == ComponentStatus.TERMINATED);
            assert (c2.getStatus() == ComponentStatus.TERMINATED);
            assert (c3.getStatus() == ComponentStatus.TERMINATED);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(new CacheContainer[]{cm});
            throw throwable;
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{cm});
    }

    public void testDefiningConfigurationValidation() {
        EmbeddedCacheManager cm;
        block13: {
            block12: {
                block11: {
                    cm = TestCacheManagerFactory.createLocalCacheManager(false);
                    try {
                        cm.defineConfiguration("cache1", (Configuration)null);
                        assert (false) : "Should fail";
                    }
                    catch (NullPointerException npe) {
                        if ($assertionsDisabled || npe.getMessage() != null) break block11;
                        throw new AssertionError();
                    }
                }
                try {
                    cm.defineConfiguration(null, (Configuration)null);
                    assert (false) : "Should fail";
                }
                catch (NullPointerException npe) {
                    if ($assertionsDisabled || npe.getMessage() != null) break block12;
                    throw new AssertionError();
                }
            }
            try {
                cm.defineConfiguration(null, new org.infinispan.config.Configuration());
                assert (false) : "Should fail";
            }
            catch (NullPointerException npe) {
                if ($assertionsDisabled || npe.getMessage() != null) break block13;
                throw new AssertionError();
            }
        }
        org.infinispan.config.Configuration c = cm.defineConfiguration("cache1", null, new org.infinispan.config.Configuration());
        assert (c.equalsIgnoreName((Object)cm.getDefaultConfiguration()));
        c = cm.defineConfiguration("cache1", "does-not-exist-cache", new org.infinispan.config.Configuration());
        assert (c.equalsIgnoreName((Object)cm.getDefaultConfiguration()));
    }

    public void testDefiningConfigurationWithTemplateName() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        org.infinispan.config.Configuration c = new org.infinispan.config.Configuration();
        c.setL1CacheEnabled(false);
        c.setL1OnRehash(false);
        c.setTransactionManagerLookup((TransactionManagerLookup)new GenericTransactionManagerLookup());
        c.setIsolationLevel(IsolationLevel.NONE);
        org.infinispan.config.Configuration oneCacheConfiguration = cm.defineConfiguration("oneCache", c);
        assert (oneCacheConfiguration.equalsIgnoreName((Object)c));
        assert (oneCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.NONE));
        c = new org.infinispan.config.Configuration();
        org.infinispan.config.Configuration secondCacheConfiguration = cm.defineConfiguration("secondCache", "oneCache", c);
        assert (oneCacheConfiguration.equalsIgnoreName((Object)secondCacheConfiguration));
        assert (secondCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.NONE));
        c = new org.infinispan.config.Configuration();
        c.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        org.infinispan.config.Configuration anotherSecondCacheConfiguration = cm.defineConfiguration("secondCache", "oneCache", c);
        assert (!secondCacheConfiguration.equals((Object)anotherSecondCacheConfiguration));
        assert (anotherSecondCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.SERIALIZABLE));
        assert (secondCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.NONE));
        c = new org.infinispan.config.Configuration();
        c.setExpirationMaxIdle(Long.MAX_VALUE);
        org.infinispan.config.Configuration yetAnotherSecondCacheConfiguration = cm.defineConfiguration("secondCache", "oneCache", c);
        assert (yetAnotherSecondCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.NONE));
        assert (yetAnotherSecondCacheConfiguration.getExpirationMaxIdle() == Long.MAX_VALUE);
        assert (secondCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.NONE));
        assert (anotherSecondCacheConfiguration.getIsolationLevel().equals((Object)IsolationLevel.SERIALIZABLE));
    }

    public void testDefiningConfigurationOverridingBooleans() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        org.infinispan.config.Configuration c = new org.infinispan.config.Configuration();
        c.fluent().storeAsBinary();
        org.infinispan.config.Configuration lazy = cm.defineConfiguration("storeAsBinary", c);
        assert (lazy.isStoreAsBinary());
        c = new org.infinispan.config.Configuration();
        c.fluent().eviction().strategy(EvictionStrategy.LRU).maxEntries(Integer.valueOf(1));
        org.infinispan.config.Configuration lazyLru = cm.defineConfiguration("lazyDeserializationWithLRU", "storeAsBinary", c);
        assert (lazy.isStoreAsBinary());
        assert (lazyLru.getEvictionStrategy() == EvictionStrategy.LRU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefineConfigurationTwice() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Configuration override = new ConfigurationBuilder().invocationBatching().enable().build();
            assert (override.invocationBatching().enabled());
            assert (cm.defineConfiguration("test1", override).invocationBatching().enabled());
            ConfigurationBuilder cb = new ConfigurationBuilder();
            cb.read(override);
            Configuration config = cb.build();
            assert (config.invocationBatching().enabled());
            assert (cm.defineConfiguration("test2", config).invocationBatching().enabled());
        }
        finally {
            cm.stop();
        }
    }

    public void testGetCacheConfigurationAfterDefiningSameOldConfigurationTwice() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager(false)){

            @Override
            public void call() {
                org.infinispan.config.Configuration c = new org.infinispan.config.Configuration();
                c.setInvocationBatchingEnabled(false);
                org.infinispan.config.Configuration newConfig = this.cm.defineConfiguration("new-cache", c);
                assert (!newConfig.isInvocationBatchingEnabled());
                c = new org.infinispan.config.Configuration();
                c.setInvocationBatchingEnabled(true);
                org.infinispan.config.Configuration newConfig2 = this.cm.defineConfiguration("new-cache", c);
                assert (newConfig2.isInvocationBatchingEnabled());
                assert (this.cm.getCache("new-cache").getConfiguration().isInvocationBatchingEnabled());
            }
        });
    }

    public void testGetCacheConfigurationAfterDefiningSameNewConfigurationTwice() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager(false)){

            @Override
            public void call() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                builder.invocationBatching().disable();
                Configuration newConfig = this.cm.defineConfiguration("new-cache", builder.build());
                assert (!newConfig.invocationBatching().enabled());
                builder = new ConfigurationBuilder();
                builder.invocationBatching().enable();
                Configuration newConfig2 = this.cm.defineConfiguration("new-cache", builder.build());
                assert (newConfig2.invocationBatching().enabled());
                assert (this.cm.getCache("new-cache").getCacheConfiguration().invocationBatching().enabled());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCacheNames() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            cm.defineConfiguration("one", new ConfigurationBuilder().build());
            cm.defineConfiguration("two", new ConfigurationBuilder().build());
            cm.getCache("three");
            Set cacheNames = cm.getCacheNames();
            assert (3 == cacheNames.size());
            assert (cacheNames.contains("one"));
            assert (cacheNames.contains("two"));
            assert (cacheNames.contains("three"));
        }
        finally {
            cm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheStopTwice() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            cache.stop();
            cache.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheManagerStopTwice() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            localCacheManager.stop();
            localCacheManager.stop();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class})
    public void testCacheStopManagerStopFollowedByGetCache() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            cache.stop();
            localCacheManager.stop();
            localCacheManager.getCache();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class})
    public void testCacheStopManagerStopFollowedByCacheOp() {
        EmbeddedCacheManager localCacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache cache = localCacheManager.getCache();
            cache.put((Object)"k", (Object)"v");
            cache.stop();
            localCacheManager.stop();
            cache.put((Object)"k", (Object)"v2");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(localCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(localCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveNonExistentCache(Method m) {
        EmbeddedCacheManager manager = this.getManagerWithStore(m, false, false);
        try {
            manager.getCache("cache");
            manager.removeCache("does-not-exist");
        }
        finally {
            manager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveCacheLocal(Method m) {
        EmbeddedCacheManager manager = this.getManagerWithStore(m, false, false);
        try {
            Cache cache = manager.getCache("cache");
            cache.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
            cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
            cache.put((Object)TestingUtil.k(m, 3), (Object)TestingUtil.v(m, 3));
            DummyInMemoryCacheStore store = this.getDummyStore(cache);
            DataContainer data = this.getDataContainer(cache);
            assert (!store.isEmpty());
            assert (0 != data.size());
            manager.removeCache("cache");
            assert (store.isEmpty());
            assert (0 == data.size());
            manager.removeCache("cache");
            assert (store.isEmpty());
            assert (0 == data.size());
        }
        finally {
            manager.stop();
        }
    }

    public void testCacheManagerRestartReusingConfigurations() {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false), TestCacheManagerFactory.createCacheManager(CacheMode.REPL_SYNC, false)}){

            @Override
            public void call() {
                EmbeddedCacheManager cm1 = this.cms[0];
                EmbeddedCacheManager cm2 = this.cms[1];
                Cache c1 = cm1.getCache();
                cm2.getCache();
                GlobalConfiguration globalCfg = cm1.getCacheManagerConfiguration();
                Configuration cfg = c1.getCacheConfiguration();
                cm1.stop();
                TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(globalCfg, cfg)){

                    @Override
                    public void call() {
                        Cache c = this.cm.getCache();
                        c.put((Object)1, (Object)"v1");
                        AssertJUnit.assertEquals((Object)"v1", (Object)c.get((Object)1));
                    }
                });
            }
        });
    }

    public void testRemoveCacheClusteredLocalStores(Method m) throws Exception {
        this.doTestRemoveCacheClustered(m, false);
    }

    public void testRemoveCacheClusteredSharedStores(Method m) throws Exception {
        this.doTestRemoveCacheClustered(m, true);
    }

    private EmbeddedCacheManager getManagerWithStore(Method m, boolean isClustered, boolean isStoreShared) {
        return this.getManagerWithStore(m, isClustered, isStoreShared, "store-");
    }

    private EmbeddedCacheManager getManagerWithStore(Method m, boolean isClustered, boolean isStoreShared, String storePrefix) {
        String storeName = storePrefix + m.getName();
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.loaders().shared(isStoreShared).addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore(storeName)).clustering().cacheMode(isClustered ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().clusteredDefault();
        gcb.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        return TestCacheManagerFactory.createClusteredCacheManager(gcb, c);
    }

    private void doTestRemoveCacheClustered(final Method m, boolean isStoreShared) {
        TestingUtil.withCacheManagers(new MultiCacheManagerCallable(new EmbeddedCacheManager[]{this.getManagerWithStore(m, true, isStoreShared, "store1-"), this.getManagerWithStore(m, true, isStoreShared, "store2-")}){

            @Override
            public void call() {
                EmbeddedCacheManager manager1 = this.cms[0];
                EmbeddedCacheManager manager2 = this.cms[0];
                Cache cache1 = manager1.getCache("cache", true);
                Cache cache2 = manager2.getCache("cache", true);
                assert (cache1 != null);
                assert (cache2 != null);
                assert (manager1.cacheExists("cache"));
                assert (manager2.cacheExists("cache"));
                cache1.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
                cache1.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
                cache1.put((Object)TestingUtil.k(m, 3), (Object)TestingUtil.v(m, 3));
                cache2.put((Object)TestingUtil.k(m, 4), (Object)TestingUtil.v(m, 4));
                cache2.put((Object)TestingUtil.k(m, 5), (Object)TestingUtil.v(m, 5));
                DummyInMemoryCacheStore store1 = CacheManagerTest.this.getDummyStore(cache1);
                DataContainer data1 = CacheManagerTest.this.getDataContainer(cache1);
                DummyInMemoryCacheStore store2 = CacheManagerTest.this.getDummyStore(cache2);
                DataContainer data2 = CacheManagerTest.this.getDataContainer(cache2);
                assert (!store1.isEmpty());
                assert (5 == data1.size());
                assert (!store2.isEmpty());
                assert (5 == data2.size());
                manager1.removeCache("cache");
                assert (!manager1.cacheExists("cache"));
                assert (!manager2.cacheExists("cache"));
                assert (null == manager1.getCache("cache", false));
                assert (null == manager2.getCache("cache", false));
                assert (store1.isEmpty());
                assert (0 == data1.size());
                assert (store2.isEmpty());
                assert (0 == data2.size());
            }
        });
    }

    private DummyInMemoryCacheStore getDummyStore(Cache cache1) {
        return (DummyInMemoryCacheStore)TestingUtil.extractComponent(cache1, CacheLoaderManager.class).getCacheLoader();
    }

    private DataContainer getDataContainer(Cache cache) {
        return TestingUtil.extractComponent(cache, DataContainer.class);
    }
}

