/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.test.data.Key;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;

public class PojoWithAttributes {
    final int age;
    final CacheEntry entry;
    final Key key;
    final UUID uuid;

    public PojoWithAttributes(int age, String key) {
        this.age = age;
        this.entry = TestInternalCacheEntryFactory.create("internalkey-" + key, "internalvalue-" + age, age * 17);
        this.key = new Key(key, false);
        this.uuid = UUID.randomUUID();
    }

    PojoWithAttributes(int age, CacheEntry entry, Key key, UUID uuid) {
        this.age = age;
        this.entry = entry;
        this.key = key;
        this.uuid = uuid;
    }

    static void writeObject(ObjectOutput output, PojoWithAttributes pojo) throws IOException {
        output.writeInt(pojo.age);
        output.writeObject(pojo.entry);
        output.writeObject(pojo.key);
        output.writeObject(pojo.uuid);
    }

    static PojoWithAttributes readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int age = input.readInt();
        CacheEntry entry = (CacheEntry)input.readObject();
        Key key = (Key)input.readObject();
        UUID uuid = (UUID)input.readObject();
        return new PojoWithAttributes(age, entry, key, uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoWithAttributes that = (PojoWithAttributes)o;
        if (this.age != that.age) {
            return false;
        }
        if (this.entry != null ? !this.entry.equals(that.entry) : that.entry != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
    }

    public int hashCode() {
        int result = this.age;
        result = 31 * result + (this.entry != null ? this.entry.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        return result;
    }
}

