/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collections;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.AbstractDelegatingMarshaller;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.SharedStreamMultiMarshallerTest", enabled=true)
public class SharedStreamMultiMarshallerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharingStream() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager();
        cm.getCache();
        JGroupsAddress address = new JGroupsAddress((Address)new IpAddress(12345));
        PutKeyValueCommand cmd = new PutKeyValueCommand((Object)"k", (Object)"v", false, null, 0L, 0L, Collections.emptySet());
        try {
            AbstractDelegatingMarshaller globalMarshal = TestingUtil.extractGlobalMarshaller(cm);
            ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(1024);
            ObjectOutput globalOO = globalMarshal.startObjectOutput((OutputStream)baos, false, 1024);
            try {
                globalOO.writeObject(address);
                globalOO.flush();
                globalOO.writeInt(baos.size());
                globalOO.flush();
                AbstractDelegatingMarshaller cacheMarshaller = TestingUtil.extractCacheMarshaller(cm.getCache());
                ObjectOutput cacheOO = cacheMarshaller.startObjectOutput((OutputStream)baos, true, 1024);
                try {
                    cacheOO.writeObject(cmd);
                }
                finally {
                    cacheMarshaller.finishObjectOutput(cacheOO);
                }
            }
            finally {
                globalMarshal.finishObjectOutput(globalOO);
            }
            byte[] bytes = new byte[baos.size()];
            System.arraycopy(baos.getRawBuffer(), 0, bytes, 0, bytes.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInput globalOI = globalMarshal.startObjectInput((InputStream)bais, false);
            try {
                AssertJUnit.assertEquals((Object)address, (Object)globalOI.readObject());
                int offset = globalOI.readInt();
                AbstractDelegatingMarshaller cacheMarshaller = TestingUtil.extractCacheMarshaller(cm.getCache());
                bais = new ByteArrayInputStream(bytes, offset + 4, bytes.length);
                ObjectInput cacheOI = cacheMarshaller.startObjectInput((InputStream)bais, true);
                try {
                    AssertJUnit.assertEquals((Object)cmd, (Object)cacheOI.readObject());
                }
                finally {
                    cacheMarshaller.finishObjectInput(cacheOI);
                }
            }
            finally {
                globalMarshal.finishObjectInput(globalOI);
            }
        }
        finally {
            cm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndividualStream() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager();
        cm.getCache();
        JGroupsAddress address = new JGroupsAddress((Address)new IpAddress(12345));
        PutKeyValueCommand cmd = new PutKeyValueCommand((Object)"k", (Object)"v", false, null, 0L, 0L, Collections.emptySet());
        try {
            AbstractDelegatingMarshaller globalMarshal = TestingUtil.extractGlobalMarshaller(cm);
            ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(1024);
            ObjectOutput globalOO = globalMarshal.startObjectOutput((OutputStream)baos, false, 1024);
            try {
                globalOO.writeObject(address);
            }
            finally {
                globalMarshal.finishObjectOutput(globalOO);
            }
            byte[] bytes = new byte[baos.size()];
            System.arraycopy(baos.getRawBuffer(), 0, bytes, 0, bytes.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInput globalOI = globalMarshal.startObjectInput((InputStream)bais, false);
            try {
                AssertJUnit.assertEquals((Object)address, (Object)globalOI.readObject());
            }
            finally {
                globalMarshal.finishObjectInput(globalOI);
            }
        }
        finally {
            cm.stop();
        }
    }
}

