/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.List;
import org.infinispan.notifications.IncorrectListenerException;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachelistener.ListenerRegistrationTest")
public class ListenerRegistrationTest
extends AbstractInfinispanTest {
    public void testControl() {
        TestControlListener l = new TestControlListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        n.addListener((Object)l);
        AssertJUnit.assertEquals((int)1, (int)n.getListeners().size());
    }

    public void testCacheListenerNoMethods() {
        TestCacheListenerNoMethodsListener l = new TestCacheListenerNoMethodsListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        n.addListener((Object)l);
        AssertJUnit.assertEquals((String)"Hello", (String)((Object)l).toString());
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testNonAnnotatedListener() {
        TestNonAnnotatedListener l = new TestNonAnnotatedListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept an un-annotated cache listener");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testNonPublicListener() {
        TestNonPublicListener l = new TestNonPublicListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a private callback class");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testNonPublicListenerMethod() {
        TestNonPublicListenerMethodListener l = new TestNonPublicListenerMethodListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        n.addListener((Object)l);
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testNonVoidReturnTypeMethod() {
        TestNonVoidReturnTypeMethodListener l = new TestNonVoidReturnTypeMethodListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a listener method with a return type");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testIncorrectMethodSignature1() {
        TestIncorrectMethodSignature1Listener l = new TestIncorrectMethodSignature1Listener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testIncorrectMethodSignature2() {
        TestIncorrectMethodSignature2Listener l = new TestIncorrectMethodSignature2Listener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testIncorrectMethodSignature3() {
        TestIncorrectMethodSignature3Listener l = new TestIncorrectMethodSignature3Listener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testUnassignableMethodSignature() {
        TestUnassignableMethodSignatureListener l = new TestUnassignableMethodSignatureListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
        AssertJUnit.assertTrue((String)"No listeners should be registered.", (boolean)n.getListeners().isEmpty());
    }

    public void testPartlyUnassignableMethodSignature() {
        TestPartlyUnassignableMethodSignatureListener l = new TestPartlyUnassignableMethodSignatureListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        try {
            n.addListener((Object)l);
            AssertJUnit.fail((String)"Should not accept a cache listener with a bad method signature");
        }
        catch (IncorrectListenerException incorrectListenerException) {
            // empty catch block
        }
    }

    public void testMultipleMethods() {
        TestMultipleMethodsListener l = new TestMultipleMethodsListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        n.addListener((Object)l);
        List invocations = n.cacheEntryVisitedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        invocations = n.cacheEntryRemovedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        AssertJUnit.assertEquals((int)1, (int)n.getListeners().size());
    }

    public void testMultipleAnnotationsOneMethod() {
        TestMultipleAnnotationsOneMethodListener l = new TestMultipleAnnotationsOneMethodListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        n.addListener((Object)l);
        List invocations = n.cacheEntryVisitedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        invocations = n.cacheEntryRemovedListeners;
        AssertJUnit.assertEquals((int)1, (int)invocations.size());
        AssertJUnit.assertEquals((int)1, (int)n.getListeners().size());
    }

    public void testMultipleMethodsOneAnnotation() {
        TestMultipleMethodsOneAnnotationListener l = new TestMultipleMethodsOneAnnotationListener();
        CacheNotifierImpl n = new CacheNotifierImpl();
        n.addListener((Object)l);
        List invocations = n.cacheEntryVisitedListeners;
        AssertJUnit.assertEquals((int)2, (int)invocations.size());
        AssertJUnit.assertEquals((int)1, (int)n.getListeners().size());
    }

    @Listener
    public static class TestMultipleMethodsOneAnnotationListener {
        @CacheEntryVisited
        public void callback1(Event e) {
        }

        @CacheEntryVisited
        public void callback2(Event e) {
        }
    }

    @Listener
    public static class TestMultipleAnnotationsOneMethodListener {
        @CacheEntryRemoved
        @CacheEntryVisited
        public void callback(Event nme) {
        }
    }

    @Listener
    public static class TestMultipleMethodsListener {
        @CacheEntryVisited
        public void callback1(Event e) {
        }

        @CacheEntryRemoved
        public void callback2(Event e) {
        }
    }

    @Listener
    public static class TestPartlyUnassignableMethodSignatureListener {
        @CacheEntryVisited
        @CacheEntryRemoved
        public void callback(CacheEntryRemovedEvent e) {
        }
    }

    @Listener
    public static class TestUnassignableMethodSignatureListener {
        @CacheEntryVisited
        public void callback(CacheEntryRemovedEvent e) {
        }
    }

    @Listener
    public static class TestIncorrectMethodSignature3Listener {
        @CacheEntryVisited
        public void callback(Event e, String ... s) {
        }
    }

    @Listener
    public static class TestIncorrectMethodSignature2Listener {
        @CacheEntryVisited
        public void callback(Event e, String s) {
        }
    }

    @Listener
    public static class TestIncorrectMethodSignature1Listener {
        @CacheEntryVisited
        public void callback() {
        }
    }

    @Listener
    public static class TestNonVoidReturnTypeMethodListener {
        @CacheEntryVisited
        public String callback(Event e) {
            return "Hello";
        }
    }

    @Listener
    public static class TestNonPublicListenerMethodListener {
        @CacheEntryVisited
        protected void callback(Event e) {
        }
    }

    @Listener
    protected static class TestNonPublicListener {
        protected TestNonPublicListener() {
        }

        @CacheEntryVisited
        public void callback() {
        }
    }

    public static class TestNonAnnotatedListener {
        public String toString() {
            return "Hello";
        }
    }

    @Listener
    public static class TestCacheListenerNoMethodsListener {
        public String toString() {
            return "Hello";
        }
    }

    @Listener
    public static class TestControlListener {
        @CacheEntryVisited
        @CacheEntryRemoved
        public void callback(Event e) {
        }
    }
}

