/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.PreloadingWithWriteBehindTest")
public class PreloadingWithWriteBehindTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder dccc = PreloadingWithWriteBehindTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        ((DummyInMemoryCacheStoreConfigurationBuilder)dccc.loaders().preload(true).addStore(DummyInMemoryCacheStoreConfigurationBuilder.class)).storeName("PreloadingWithWriteBehindTest").async().enabled(true);
        dccc.transaction().cacheStopTimeout(50L, TimeUnit.SECONDS);
        return TestCacheManagerFactory.createCacheManager(dccc);
    }

    public void testPreload() {
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.put((Object)"k3", (Object)"v3");
        this.getDummyLoader().clearStats();
        this.cache.stop();
        this.cache.start();
        AssertJUnit.assertEquals((int)3, (int)this.cache.size());
        Integer loads = this.getDummyLoader().stats().get("load");
        AssertJUnit.assertEquals((Object)0, (Object)loads);
    }

    private DummyInMemoryCacheStore getDummyLoader() {
        AsyncStore asyncStore = (AsyncStore)TestingUtil.getCacheLoader(this.cache);
        return (DummyInMemoryCacheStore)AsyncStore.undelegateCacheLoader((CacheLoader)asyncStore);
    }
}

