/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.SingleClusterMemberTransportInvokeTest")
public class SingleClusterMemberTransportInvokeTest
extends MultipleCacheManagersTest {
    final String key = "k";
    final String value = "v";
    final String value2 = "v2";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = SingleClusterMemberTransportInvokeTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.createClusteredCaches(1, "replSync", c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeRemotelyWhenSingleMember() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Transport mockTransport = (Transport)Mockito.mock(Transport.class);
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport originalTransport = TestingUtil.extractComponent(cache1, Transport.class);
        try {
            Address mockAddress1 = (Address)Mockito.mock(Address.class);
            ArrayList<Address> memberList = new ArrayList<Address>(1);
            memberList.add(mockAddress1);
            Mockito.when((Object)mockTransport.getMembers()).thenReturn(memberList);
            Mockito.when((Object)mockTransport.getAddress()).thenReturn(null);
            rpcManager.setTransport(mockTransport);
            cache1.put((Object)"k", (Object)"v");
        }
        finally {
            if (rpcManager != null) {
                rpcManager.setTransport(originalTransport);
            }
        }
    }
}

