/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncReplPessimisticLockingTest")
public class SyncReplPessimisticLockingTest
extends MultipleCacheManagersTest {
    String k = "key";
    String v = "value";

    public SyncReplPessimisticLockingTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected Configuration.CacheMode getCacheMode() {
        return Configuration.CacheMode.REPL_SYNC;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = SyncReplPessimisticLockingTest.getDefaultClusteredConfig(this.getCacheMode(), true);
        cfg.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        cfg.setLockAcquisitionTimeout(500L);
        cfg.setUseEagerLocking(true);
        this.createClusteredCaches(2, "testcache", cfg);
    }

    public void testBasicOperation() throws Exception {
        this.testBasicOperationHelper(false);
        this.testBasicOperationHelper(true);
    }

    public void testLocksReleasedWithNoMods() throws Exception {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.get((Object)this.k);
        mgr.commit();
        this.assertNotLocked(cache1);
        this.assertNotLocked(cache2);
        cache1.clear();
        cache2.clear();
    }

    public void testReplaceNonExistentKey() throws Exception {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        Object old = cache1.replace((Object)this.k, (Object)"blah");
        boolean replaced = cache1.replace((Object)this.k, (Object)"Vladimir", (Object)"Blagojevic");
        assert (!replaced);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        mgr.commit();
        this.assertNotLocked(cache1);
        this.assertNotLocked(cache2);
        cache1.clear();
        cache2.clear();
    }

    private void testBasicOperationHelper(boolean useCommit) throws Exception {
        Cache cache1 = this.cache(0, "testcache");
        Cache cache2 = this.cache(1, "testcache");
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)this.k));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)this.k));
        String name = "Infinispan";
        TransactionManager mgr = TestingUtil.getTransactionManager(cache1);
        mgr.begin();
        cache1.put((Object)this.k, (Object)name);
        this.assertKeyLockedCorrectly(this.k, "testcache");
        String key2 = "name";
        cache1.put((Object)key2, (Object)"Vladimir");
        this.assertKeyLockedCorrectly(key2, "testcache");
        String key3 = "product";
        String key4 = "org";
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put(key3, "Infinispan");
        newMap.put(key4, "JBoss");
        cache1.putAll(newMap);
        this.assertLocked(this.getLockOwner(key3, "testcache"), (Object)key3);
        this.assertLocked(this.getLockOwner(key4, "testcache"), (Object)key4);
        if (useCommit) {
            mgr.commit();
        } else {
            mgr.rollback();
        }
        if (useCommit) {
            AssertJUnit.assertEquals((Object)name, (Object)cache1.get((Object)this.k));
            AssertJUnit.assertEquals((String)"Should have replicated", (Object)name, (Object)cache2.get((Object)this.k));
        } else {
            AssertJUnit.assertEquals(null, (Object)cache1.get((Object)this.k));
            AssertJUnit.assertEquals((String)"Should not have replicated", null, (Object)cache2.get((Object)this.k));
        }
        cache2.remove((Object)this.k);
        cache2.remove((Object)key2);
        cache2.remove((Object)key3);
        cache2.remove((Object)key4);
    }

    public void testSimpleCommit() throws Throwable {
        this.tm(0, "testcache").begin();
        this.cache(0, "testcache").put((Object)"k", (Object)"v");
        this.tm(0, "testcache").commit();
        AssertJUnit.assertEquals((Object)this.cache(0, "testcache").get((Object)"k"), (Object)"v");
        AssertJUnit.assertEquals((Object)this.cache(1, "testcache").get((Object)"k"), (Object)"v");
        this.assertNotLocked("testcache", (Object)"k");
        this.tm(0, "testcache").begin();
        this.cache(0, "testcache").put((Object)"k", (Object)"v");
        this.cache(0, "testcache").remove((Object)"k");
        this.tm(0, "testcache").commit();
        AssertJUnit.assertEquals((Object)this.cache(0, "testcache").get((Object)"k"), null);
        AssertJUnit.assertEquals((Object)this.cache(1, "testcache").get((Object)"k"), null);
        this.assertNotLocked("testcache", (Object)"k");
    }

    public void testSimpleRollabck() throws Throwable {
        this.tm(0, "testcache").begin();
        this.cache(0, "testcache").put((Object)"k", (Object)"v");
        this.tm(0, "testcache").rollback();
        assert (!this.lockManager(1, "testcache").isLocked((Object)"k"));
        AssertJUnit.assertEquals((Object)this.cache(0, "testcache").get((Object)"k"), null);
        AssertJUnit.assertEquals((Object)this.cache(1, "testcache").get((Object)"k"), null);
        assert (!this.lockManager(0, "testcache").isLocked((Object)"k"));
    }
}

