/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.VersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
@CleanupAfterMethod
public abstract class BaseOperationsDuringStateTransferTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(BaseOperationsDuringStateTransferTest.class);
    private final CacheMode cacheMode;
    private final boolean isTransactional;
    private final boolean isOptimistic;
    private final boolean supportsConcurrentUpdates;
    private ConfigurationBuilder cacheConfigBuilder;
    private ReclosableLatch transportGate;

    protected BaseOperationsDuringStateTransferTest(CacheMode cacheMode, boolean isTransactional, boolean isOptimistic, boolean supportsConcurrentUpdates) {
        this.cacheMode = cacheMode;
        this.isTransactional = isTransactional;
        this.isOptimistic = isOptimistic;
        this.supportsConcurrentUpdates = supportsConcurrentUpdates;
    }

    @Override
    protected void createCacheManagers() {
        this.cacheConfigBuilder = BaseOperationsDuringStateTransferTest.getDefaultClusteredCacheConfig(this.cacheMode, this.isTransactional, true);
        if (this.isTransactional) {
            this.cacheConfigBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).syncCommitPhase(true).syncRollbackPhase(true);
            if (this.isOptimistic) {
                this.cacheConfigBuilder.transaction().lockingMode(LockingMode.OPTIMISTIC).locking().writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ).versioning().enable().scheme(VersioningScheme.SIMPLE);
            } else {
                this.cacheConfigBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
            }
        }
        this.cacheConfigBuilder.clustering().hash().numSegments(10).numOwners(2).l1().disable().onRehash(false).locking().lockAcquisitionTimeout(1000L);
        this.cacheConfigBuilder.locking().supportsConcurrentUpdates(this.supportsConcurrentUpdates);
        this.cacheConfigBuilder.clustering().stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false);
        this.transportGate = new ReclosableLatch(true);
        GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
        globalConfigurationBuilder.transport().transport((Transport)new JGroupsTransport(){

            public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) throws Exception {
                if (rpcCommand instanceof CacheTopologyControlCommand) {
                    try {
                        BaseOperationsDuringStateTransferTest.this.transportGate.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
            }
        });
        this.addClusterEnabledCacheManager(globalConfigurationBuilder, this.cacheConfigBuilder);
        this.waitForClusterToForm();
    }

    public void testRemove() throws Exception {
        this.cache(0).put((Object)"myKey", (Object)"myValue");
        final CountDownLatch removeStartedLatch = new CountDownLatch(1);
        final CountDownLatch removeProceedLatch = new CountDownLatch(1);
        boolean isVersioningEnabled = this.cache(0).getCacheConfiguration().versioning().enabled();
        this.cacheConfigBuilder.customInterceptors().addInterceptor().after(isVersioningEnabled ? VersionedEntryWrappingInterceptor.class : EntryWrappingInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof RemoveCommand) {
                    removeStartedLatch.countDown();
                    if (!removeProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        this.transportGate.close();
        log.info((Object)"Adding a new node ..");
        this.addClusterEnabledCacheManager(this.cacheConfigBuilder);
        log.info((Object)"Added a new node");
        CacheTopology cacheTopology = this.advancedCache(1).getComponentRegistry().getStateTransferManager().getCacheTopology();
        Assert.assertNull((Object)cacheTopology.getPendingCH());
        Assert.assertTrue((boolean)cacheTopology.getMembers().contains(this.address(0)));
        Assert.assertFalse((boolean)cacheTopology.getMembers().contains(this.address(1)));
        Assert.assertFalse((boolean)cacheTopology.getCurrentCH().getMembers().contains(this.address(1)));
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        Future<Object> getFuture = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return BaseOperationsDuringStateTransferTest.this.cache(1).remove((Object)"myKey");
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "PUT failed: %s", (Object)e.getMessage());
                    throw e;
                }
            }
        });
        if (!removeStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        this.transportGate.open();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1));
        Assert.assertEquals((long)1L, (long)this.cache(1).keySet().size());
        removeProceedLatch.countDown();
        Object oldVal = getFuture.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)oldVal);
        Assert.assertEquals((Object)"myValue", (Object)oldVal);
        Assert.assertNull((Object)this.cache(0).get((Object)"myKey"));
        Assert.assertNull((Object)this.cache(1).get((Object)"myKey"));
    }

    public void testPut() throws Exception {
        this.cache(0).put((Object)"myKey", (Object)"myValue");
        final CountDownLatch putStartedLatch = new CountDownLatch(1);
        final CountDownLatch putProceedLatch = new CountDownLatch(1);
        boolean isVersioningEnabled = this.cache(0).getCacheConfiguration().versioning().enabled();
        this.cacheConfigBuilder.customInterceptors().addInterceptor().after(isVersioningEnabled ? VersionedEntryWrappingInterceptor.class : EntryWrappingInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof PutKeyValueCommand && !((PutKeyValueCommand)cmd).hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    putStartedLatch.countDown();
                    if (!putProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        this.transportGate.close();
        log.info((Object)"Adding a new node ..");
        this.addClusterEnabledCacheManager(this.cacheConfigBuilder);
        log.info((Object)"Added a new node");
        CacheTopology cacheTopology = this.advancedCache(1).getComponentRegistry().getStateTransferManager().getCacheTopology();
        Assert.assertNull((Object)cacheTopology.getPendingCH());
        Assert.assertTrue((boolean)cacheTopology.getMembers().contains(this.address(0)));
        Assert.assertFalse((boolean)cacheTopology.getMembers().contains(this.address(1)));
        Assert.assertFalse((boolean)cacheTopology.getCurrentCH().getMembers().contains(this.address(1)));
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        Future<Object> getFuture = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return BaseOperationsDuringStateTransferTest.this.cache(1).put((Object)"myKey", (Object)"newValue");
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "PUT failed: %s", (Object)e.getMessage());
                    throw e;
                }
            }
        });
        if (!putStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        this.transportGate.open();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1));
        Assert.assertEquals((long)1L, (long)this.cache(1).keySet().size());
        putProceedLatch.countDown();
        Object oldVal = getFuture.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)oldVal);
        Assert.assertEquals((Object)"myValue", (Object)oldVal);
        Assert.assertEquals((Object)"newValue", (Object)this.cache(0).get((Object)"myKey"));
        Assert.assertEquals((Object)"newValue", (Object)this.cache(1).get((Object)"myKey"));
    }

    public void testReplace() throws Exception {
        this.cache(0).put((Object)"myKey", (Object)"myValue");
        final CountDownLatch replaceStartedLatch = new CountDownLatch(1);
        final CountDownLatch replaceProceedLatch = new CountDownLatch(1);
        boolean isVersioningEnabled = this.cache(0).getCacheConfiguration().versioning().enabled();
        this.cacheConfigBuilder.customInterceptors().addInterceptor().after(isVersioningEnabled ? VersionedEntryWrappingInterceptor.class : EntryWrappingInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof ReplaceCommand) {
                    replaceStartedLatch.countDown();
                    if (!replaceProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        this.transportGate.close();
        log.info((Object)"Adding a new node ..");
        this.addClusterEnabledCacheManager(this.cacheConfigBuilder);
        log.info((Object)"Added a new node");
        CacheTopology cacheTopology = this.advancedCache(1).getComponentRegistry().getStateTransferManager().getCacheTopology();
        Assert.assertNull((Object)cacheTopology.getPendingCH());
        Assert.assertTrue((boolean)cacheTopology.getMembers().contains(this.address(0)));
        Assert.assertFalse((boolean)cacheTopology.getMembers().contains(this.address(1)));
        Assert.assertFalse((boolean)cacheTopology.getCurrentCH().getMembers().contains(this.address(1)));
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        Future<Object> getFuture = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return BaseOperationsDuringStateTransferTest.this.cache(1).replace((Object)"myKey", (Object)"newValue");
                }
                catch (Exception e) {
                    log.errorf((Throwable)e, "REPLACE failed: %s", (Object)e.getMessage());
                    throw e;
                }
            }
        });
        if (!replaceStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        this.transportGate.open();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1));
        Assert.assertEquals((long)1L, (long)this.cache(1).keySet().size());
        replaceProceedLatch.countDown();
        Object oldVal = getFuture.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)oldVal);
        Assert.assertEquals((Object)"myValue", (Object)oldVal);
        Assert.assertEquals((Object)"newValue", (Object)this.cache(0).get((Object)"myKey"));
        Assert.assertEquals((Object)"newValue", (Object)this.cache(1).get((Object)"myKey"));
    }

    public void testGet() throws Exception {
        this.cache(0).put((Object)"myKey", (Object)"myValue");
        final CountDownLatch applyStateProceedLatch = new CountDownLatch(1);
        final CountDownLatch applyStateStartedLatch = new CountDownLatch(1);
        this.cacheConfigBuilder.customInterceptors().addInterceptor().before(InvocationContextInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    applyStateStartedLatch.countDown();
                    if (!applyStateProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        final CountDownLatch getKeyStartedLatch = new CountDownLatch(1);
        final CountDownLatch getKeyProceedLatch = new CountDownLatch(1);
        this.cacheConfigBuilder.customInterceptors().addInterceptor().before(CallInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof GetKeyValueCommand) {
                    getKeyStartedLatch.countDown();
                    if (!getKeyProceedLatch.await(15L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        log.info((Object)"Adding a new node ..");
        this.addClusterEnabledCacheManager(this.cacheConfigBuilder);
        log.info((Object)"Added a new node");
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        if (!applyStateStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        Assert.assertTrue((boolean)this.cache(1).keySet().isEmpty());
        Future<Object> getFuture = this.fork(new Callable<Object>(){

            @Override
            public Object call() {
                return BaseOperationsDuringStateTransferTest.this.cache(1).get((Object)"myKey");
            }
        });
        if (!getKeyStartedLatch.await(15L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        applyStateProceedLatch.countDown();
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1));
        Assert.assertEquals((long)1L, (long)this.cache(1).keySet().size());
        getKeyProceedLatch.countDown();
        Object value = getFuture.get(15L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"myValue", (Object)value);
    }
}

