/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.tx.dld.ControlledRpcManager;
import org.jgroups.protocols.DISCARD;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.MergeDuringReplaceTest")
@CleanupAfterMethod
public class MergeDuringReplaceTest
extends MultipleCacheManagersTest {
    private DISCARD[] discard;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfig = MergeDuringReplaceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.createClusteredCaches(3, defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        DISCARD d1 = TestingUtil.getDiscardForCache(this.cache(0));
        d1.setExcludeItself(true);
        DISCARD d2 = TestingUtil.getDiscardForCache(this.cache(1));
        d2.setExcludeItself(true);
        DISCARD d3 = TestingUtil.getDiscardForCache(this.cache(2));
        d3.setExcludeItself(true);
        this.discard = new DISCARD[]{d1, d2, d3};
    }

    public void testMergeDuringReplace() throws Exception {
        String key = "myKey";
        String value = "myValue";
        this.cache(0).put((Object)"myKey", (Object)"myValue");
        ConsistentHash ch = this.cache(0).getAdvancedCache().getComponentRegistry().getStateTransferManager().getCacheTopology().getCurrentCH();
        ArrayList members = new ArrayList(ch.getMembers());
        List owners = ch.locateOwners((Object)"myKey");
        members.removeAll(owners);
        int nonOwner = ch.getMembers().indexOf(members.get(0));
        final Cache c = this.cache(nonOwner);
        List partition1 = this.caches();
        partition1.remove(c);
        ControlledRpcManager controlledRpcManager = new ControlledRpcManager(c.getAdvancedCache().getRpcManager());
        TestingUtil.replaceComponent(c, RpcManager.class, controlledRpcManager, true);
        controlledRpcManager.blockBefore(ReplaceCommand.class);
        Future<Boolean> future = this.fork(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return c.replace((Object)"myKey", (Object)"myValue", (Object)"myNewValue");
            }
        });
        this.discard[nonOwner].setDiscardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, partition1.get(0), partition1.get(1));
        TestingUtil.blockUntilViewsReceived(30000L, false, c);
        TestingUtil.waitForRehashToComplete(partition1.get(0), partition1.get(1));
        TestingUtil.waitForRehashToComplete(c);
        controlledRpcManager.stopBlocking();
        try {
            future.get();
            Assert.fail((String)"The expected ExecutionException did not occur!");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof SuspectException));
            Assert.assertTrue((boolean)cause.getMessage().startsWith("One or more nodes have left the cluster while replicating command"));
        }
    }
}

