/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Arrays;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.RebalancePolicyJmxTest")
public class RebalancePolicyJmxTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder());
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r1"), this.getConfigurationBuilder());
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(false);
        return cb;
    }

    private GlobalConfigurationBuilder getGlobalConfigurationBuilder(String rackId) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.globalJmxStatistics().enable().mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup()).transport().rackId(rackId);
        return gcb;
    }

    public void testRebalanceSuspend() throws Exception {
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        String domain0 = this.manager(1).getCacheManagerConfiguration().globalJmxStatistics().domain();
        ObjectName ltmName0 = TestingUtil.getCacheManagerObjectName(domain0, "DefaultCacheManager", "LocalTopologyManager");
        String domain1 = this.manager(1).getCacheManagerConfiguration().globalJmxStatistics().domain();
        ObjectName ltmName1 = TestingUtil.getCacheManagerObjectName(domain1, "DefaultCacheManager", "LocalTopologyManager");
        StateTransferManager stm0 = TestingUtil.extractComponent(this.cache(0), StateTransferManager.class);
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)stm0.getCacheTopology().getCurrentCH().getMembers());
        AssertJUnit.assertNull((Object)stm0.getCacheTopology().getPendingCH());
        AssertJUnit.assertTrue((boolean)mBeanServer.isRegistered(ltmName0));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, "RebalancingEnabled")));
        mBeanServer.setAttribute(ltmName0, new Attribute("RebalancingEnabled", false));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, "RebalancingEnabled")));
        this.log.debugf("Starting 2 new nodes", new Object[0]);
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r2"), this.getConfigurationBuilder());
        this.addClusterEnabledCacheManager(this.getGlobalConfigurationBuilder("r2"), this.getConfigurationBuilder());
        this.cache(2);
        this.cache(3);
        Thread.sleep(1000L);
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName1, "RebalancingEnabled")));
        AssertJUnit.assertNull((Object)stm0.getCacheTopology().getPendingCH());
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1)), (Collection)stm0.getCacheTopology().getCurrentCH().getMembers());
        this.log.debugf("Rebalancing with nodes %s %s %s %s", new Object[]{this.address(0), this.address(1), this.address(2), this.address(3)});
        mBeanServer.setAttribute(ltmName0, new Attribute("RebalancingEnabled", true));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, "RebalancingEnabled")));
        mBeanServer.setAttribute(ltmName0, new Attribute("RebalancingEnabled", true));
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(1), this.cache(2), this.cache(3));
        AssertJUnit.assertNull((Object)stm0.getCacheTopology().getPendingCH());
        ConsistentHash ch = stm0.getCacheTopology().getCurrentCH();
        Assert.assertEquals(Arrays.asList(this.address(0), this.address(1), this.address(2), this.address(3)), (Collection)ch.getMembers());
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            Assert.assertEquals((int)2, (int)ch.locateOwnersForSegment(i).size());
        }
        mBeanServer.setAttribute(ltmName1, new Attribute("RebalancingEnabled", false));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName0, "RebalancingEnabled")));
        AssertJUnit.assertFalse((boolean)((Boolean)mBeanServer.getAttribute(ltmName1, "RebalancingEnabled")));
        mBeanServer.setAttribute(ltmName1, new Attribute("RebalancingEnabled", false));
        this.log.debugf("Stopping nodes %s %s", (Object)this.address(0), (Object)this.address(1));
        TestingUtil.killCacheManagers(this.manager(0), this.manager(1));
        Thread.sleep(1000L);
        StateTransferManager stm2 = TestingUtil.extractComponent(this.cache(2), StateTransferManager.class);
        AssertJUnit.assertNull((Object)stm2.getCacheTopology().getPendingCH());
        ch = stm2.getCacheTopology().getCurrentCH();
        Assert.assertEquals(Arrays.asList(this.address(2), this.address(3)), (Collection)ch.getMembers());
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            Assert.assertEquals((int)1, (int)ch.locateOwnersForSegment(i).size());
        }
        this.log.debugf("Rebalancing with nodes %s %s", (Object)this.address(2), (Object)this.address(3));
        String domain2 = this.manager(2).getCacheManagerConfiguration().globalJmxStatistics().domain();
        ObjectName ltmName2 = TestingUtil.getCacheManagerObjectName(domain2, "DefaultCacheManager", "LocalTopologyManager");
        String domain3 = this.manager(2).getCacheManagerConfiguration().globalJmxStatistics().domain();
        ObjectName ltmName3 = TestingUtil.getCacheManagerObjectName(domain3, "DefaultCacheManager", "LocalTopologyManager");
        mBeanServer.setAttribute(ltmName2, new Attribute("RebalancingEnabled", true));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName2, "RebalancingEnabled")));
        AssertJUnit.assertTrue((boolean)((Boolean)mBeanServer.getAttribute(ltmName3, "RebalancingEnabled")));
        TestingUtil.waitForRehashToComplete(this.cache(2), this.cache(3));
        AssertJUnit.assertNull((Object)stm2.getCacheTopology().getPendingCH());
        ch = stm2.getCacheTopology().getCurrentCH();
        Assert.assertEquals(Arrays.asList(this.address(2), this.address(3)), (Collection)ch.getMembers());
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            Assert.assertEquals((int)2, (int)ch.locateOwnersForSegment(i).size());
        }
    }
}

