/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.File;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.ReplStateTransferCacheLoaderTest")
@CleanupAfterMethod
public class ReplStateTransferCacheLoaderTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(ReplStateTransferCacheLoaderTest.class);
    private File tmpDir;
    private ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() {
        this.tmpDir = new File(TestingUtil.tmpDirectory(this));
        TestingUtil.recursiveFileRemove(this.tmpDir);
        this.builder = ReplStateTransferCacheLoaderTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true, true);
        ((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)this.builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).eviction().maxEntries(1000).strategy(EvictionStrategy.LIRS).locking().lockAcquisitionTimeout(20000L).concurrencyLevel(5000).useLockStriping(false).writeSkewCheck(false).isolationLevel(IsolationLevel.READ_COMMITTED).dataContainer().storeAsBinary().clustering().sync().replTimeout(20000L).stateTransfer().timeout(240000L).fetchInMemoryState(false).chunkSize(0).loaders().passivation(false).shared(false).preload(false).addFileCacheStore().location(new File(this.tmpDir, "store0").getAbsolutePath()).fetchPersistentState(true)).purgerThreads(3)).purgeSynchronously(true)).ignoreModifications(false)).purgeOnStartup(false);
        this.createCluster(this.builder, 1);
        this.waitForClusterToForm();
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.tmpDir);
    }

    public void testStateTransfer() throws Exception {
        int i;
        int numKeys = 300;
        for (i = 0; i < 300; ++i) {
            this.cache(0).put((Object)i, (Object)i);
        }
        log.info((Object)"Finished putting keys");
        for (i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache(0).get((Object)i));
        }
        log.info((Object)"Adding a new node ..");
        ((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)((FileCacheStoreConfigurationBuilder)this.builder.loaders().clearCacheLoaders().addFileCacheStore().location(new File(this.tmpDir, "store1").getAbsolutePath()).fetchPersistentState(true)).purgerThreads(3)).purgeSynchronously(true)).ignoreModifications(false)).purgeOnStartup(false);
        this.addClusterEnabledCacheManager(this.builder);
        log.info((Object)"Added a new node");
        for (i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache(1).get((Object)i));
        }
    }
}

