/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.testng.annotations.Test;

@Test(testName="lock.StaleLocksWithCommitDuringStateTransferTest", groups={"functional"}, enabled=false, description="This test relies on implementation details of the old state algorithm")
@CleanupAfterMethod
public class StaleLocksWithCommitDuringStateTransferTest
extends MultipleCacheManagersTest {
    Cache<MagicKey, String> c1;
    Cache<MagicKey, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.DIST_SYNC);
        cfg.setSyncReplTimeout(100L);
        cfg.setCacheStopTimeout(100);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.c1 = cm1.getCache();
        this.c2 = cm2.getCache();
        this.waitForClusterToForm();
    }

    public void testRollbackLocalFailure() throws Exception {
        this.doStateTransferInProgressTest(false, true);
    }

    public void testCommitLocalFailure() throws Exception {
        this.doStateTransferInProgressTest(true, true);
    }

    public void testRollbackRemoteFailure() throws Exception {
        this.doStateTransferInProgressTest(false, false);
    }

    public void testCommitRemoteFailure() throws Exception {
        this.doStateTransferInProgressTest(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStateTransferInProgressTest(boolean commit, final boolean failOnOriginator) throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.tm(this.c1).begin();
        this.c1.put((Object)k1, (Object)"v1");
        this.c1.put((Object)k2, (Object)"v2");
        TransactionTable txTable = TestingUtil.extractComponent(this.c1, TransactionTable.class);
        TransactionCoordinator txCoordinator = TestingUtil.extractComponent(this.c1, TransactionCoordinator.class);
        LocalTransaction localTx = txTable.getLocalTransaction(this.tm(this.c1).getTransaction());
        txCoordinator.prepare(localTx);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        Thread worker = new Thread("RehasherSim,StaleLocksWithCommitDuringStateTransferTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StateTransferLock blockFirst = TestingUtil.extractComponent(failOnOriginator ? StaleLocksWithCommitDuringStateTransferTest.this.c1 : StaleLocksWithCommitDuringStateTransferTest.this.c2, StateTransferLock.class);
                    StateTransferLock blockSecond = TestingUtil.extractComponent(failOnOriginator ? StaleLocksWithCommitDuringStateTransferTest.this.c2 : StaleLocksWithCommitDuringStateTransferTest.this.c1, StateTransferLock.class);
                    try {
                        blockFirst.acquireExclusiveTopologyLock();
                        blockSecond.acquireExclusiveTopologyLock();
                        commitLatch.countDown();
                        Thread.sleep(1000L);
                    }
                    finally {
                        blockSecond.releaseExclusiveTopologyLock();
                        blockFirst.releaseExclusiveTopologyLock();
                    }
                }
                catch (Throwable t) {
                    StaleLocksWithCommitDuringStateTransferTest.this.log.errorf(t, "Error blocking/unblocking transactions", new Object[0]);
                }
            }
        };
        worker.start();
        commitLatch.await(10L, TimeUnit.SECONDS);
        try {
            if (commit) {
                this.tm(this.c1).commit();
            } else {
                this.tm(this.c1).rollback();
            }
            this.tm(this.c1).suspend();
        }
        finally {
            worker.join();
        }
        this.assertNotLocked(this.c1, (Object)k1);
        this.assertNotLocked(this.c2, (Object)k1);
        this.assertNotLocked(this.c1, (Object)k2);
        this.assertNotLocked(this.c2, (Object)k2);
    }

    public void testRollbackSuspectFailure() throws Exception {
        this.doTestSuspect(false);
    }

    public void testCommitSuspectFailure() throws Exception {
        this.doTestSuspect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSuspect(boolean commit) throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.tm(this.c1).begin();
        this.c1.put((Object)k1, (Object)"v1");
        this.c1.put((Object)k2, (Object)"v2");
        TransactionTable txTable = TestingUtil.extractComponent(this.c1, TransactionTable.class);
        TransactionCoordinator txCoordinator = TestingUtil.extractComponent(this.c1, TransactionCoordinator.class);
        LocalTransaction localTx = txTable.getLocalTransaction(this.tm(this.c1).getTransaction());
        txCoordinator.prepare(localTx);
        InterceptorChain c2ic = TestingUtil.extractComponent(this.c2, InterceptorChain.class);
        c2ic.addInterceptorBefore(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
                if (command instanceof CommitCommand) {
                    Thread.sleep(3000L);
                }
                return super.handleDefault(ctx, command);
            }
        }, StateTransferInterceptor.class);
        Thread worker = new Thread("RehasherSim,StaleLocksWithCommitDuringStateTransferTest"){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    StaleLocksWithCommitDuringStateTransferTest.this.manager(StaleLocksWithCommitDuringStateTransferTest.this.c2).stop();
                }
                catch (InterruptedException e) {
                    StaleLocksWithCommitDuringStateTransferTest.this.log.errorf((Throwable)e, "Error stopping cache", new Object[0]);
                }
            }
        };
        worker.start();
        try {
            if (commit) {
                txCoordinator.commit(localTx, false);
            } else {
                txCoordinator.rollback(localTx);
            }
            this.tm(this.c1).suspend();
        }
        finally {
            worker.join();
        }
        this.assertNotLocked(this.c1, (Object)k1);
        this.assertNotLocked(this.c1, (Object)k2);
    }
}

