/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="stress.AsyncStoreStressTest", groups={"stress"}, enabled=true, description="Disabled by default, designed to be run manually.")
public class AsyncStoreStressTest {
    static final Log log = LogFactory.getLog(AsyncStoreStressTest.class);
    static final boolean trace = log.isTraceEnabled();
    static final int CAPACITY = Integer.getInteger("size", 100000);
    static final int LOOP_FACTOR = 10;
    static final long RUNNING_TIME = Integer.getInteger("time", 1) * 60 * 1000;
    static final Random RANDOM = new Random(12345L);
    private volatile CountDownLatch latch;
    private List<String> keys = new ArrayList<String>();
    private InternalEntryFactory entryFactory = new InternalEntryFactoryImpl();
    private Map<Object, InternalCacheEntry> expectedState = new ConcurrentHashMap<Object, InternalCacheEntry>();
    private LockContainer locks = new ReentrantPerEntryLockContainer(32);

    private Map<String, AbstractDelegatingStore> createAsyncStores() throws CacheLoaderException {
        TreeMap<String, AbstractDelegatingStore> stores = new TreeMap<String, AbstractDelegatingStore>();
        stores.put("ASYNC", (AbstractDelegatingStore)this.createAsyncStore());
        return stores;
    }

    private AsyncStore createAsyncStore() throws CacheLoaderException {
        DummyInMemoryCacheStore backendStore = this.createBackendStore("async2");
        AsyncStoreConfig asyncCfg = new AsyncStoreConfig();
        asyncCfg.modificationQueueSize(Integer.valueOf(0));
        AsyncStore store = new AsyncStore((CacheStore)backendStore, asyncCfg);
        store.init((CacheLoaderConfig)backendStore.getCacheStoreConfig(), null, (StreamingMarshaller)new TestObjectStreamMarshaller());
        store.start();
        return store;
    }

    private DummyInMemoryCacheStore createBackendStore(String storeName) throws CacheLoaderException {
        DummyInMemoryCacheStore store = new DummyInMemoryCacheStore();
        store.init((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg(storeName), null, new TestObjectStreamMarshaller());
        store.start();
        return store;
    }

    @DataProvider(name="readWriteRemove")
    public Object[][] independentReadWriteRemoveParams() {
        return new Object[][]{{CAPACITY, 3 * CAPACITY, 90, 9, 1}, {CAPACITY, 3 * CAPACITY, 9, 1, 0}};
    }

    @Test(dataProvider="readWriteRemove", enabled=true)
    public void testReadWriteRemove(int capacity, int numKeys, int readerThreads, int writerThreads, int removerThreads) throws Exception {
        System.out.printf("Testing independent read/write/remove performance with capacity %d, keys %d, readers %d, writers %d, removers %d\n", capacity, numKeys, readerThreads, writerThreads, removerThreads);
        this.generateKeyList(numKeys);
        Map<String, AbstractDelegatingStore> stores = this.createAsyncStores();
        for (Map.Entry<String, AbstractDelegatingStore> e : stores.entrySet()) {
            this.mapTestReadWriteRemove(e.getKey(), e.getValue(), numKeys, readerThreads, writerThreads, removerThreads);
            e.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapTestReadWriteRemove(String name, AbstractDelegatingStore store, int numKeys, int readerThreads, int writerThreads, int removerThreads) throws Exception {
        DummyInMemoryCacheStore delegate = (DummyInMemoryCacheStore)store.getDelegate();
        try {
            System.out.printf("[store=%s] Warming up\n", name);
            this.runMapTestReadWriteRemove(name, store, readerThreads, writerThreads, removerThreads, 1000L);
            System.out.printf("[store=%s] Testing...\n", name);
            TotalStats perf = this.runMapTestReadWriteRemove(name, store, readerThreads, writerThreads, removerThreads, RUNNING_TIME);
            System.out.printf("[store=%s] Verify contents\n", name);
            delegate.blockUntilCacheStoreContains(this.expectedState.keySet(), 60000L);
            System.out.printf("Container %-12s  ", name);
            System.out.printf("Ops/s %10.2f  ", perf.getTotalOpsPerSec());
            System.out.printf("Gets/s %10.2f  ", perf.getOpsPerSec("GET"));
            System.out.printf("Puts/s %10.2f  ", perf.getOpsPerSec("PUT"));
            System.out.printf("Removes/s %10.2f  ", perf.getOpsPerSec("REMOVE"));
            System.out.printf("HitRatio %10.2f  ", perf.getTotalHitRatio() * 100.0);
            System.out.printf("Size %10d  ", store.loadAllKeys(null).size());
            double stdDev = this.computeStdDev(store, numKeys);
            System.out.printf("StdDev %10.2f\n", stdDev);
        }
        finally {
            this.expectedState.clear();
            delegate.clear();
        }
    }

    private TotalStats runMapTestReadWriteRemove(String name, AbstractDelegatingStore store, int numReaders, int numWriters, int numRemovers, long runningTimeout) throws Exception {
        int i;
        this.latch = new CountDownLatch(1);
        TotalStats perf = new TotalStats();
        LinkedList<WorkerThread> threads = new LinkedList<WorkerThread>();
        for (i = 0; i < numReaders; ++i) {
            WorkerThread workerThread = new WorkerThread("worker-" + name + "-get-" + i, runningTimeout, perf, this.readOperation(store));
            threads.add(workerThread);
        }
        for (i = 0; i < numWriters; ++i) {
            WorkerThread workerThread = new WorkerThread("worker-" + name + "-put-" + i, runningTimeout, perf, this.writeOperation(store));
            threads.add(workerThread);
        }
        for (i = 0; i < numRemovers; ++i) {
            WorkerThread workerThread = new WorkerThread("worker-" + name + "-remove-" + i, runningTimeout, perf, this.removeOperation(store));
            threads.add(workerThread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        this.latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        return perf;
    }

    private void generateKeyList(int numKeys) {
        this.keys = null;
        this.keys = new ArrayList<String>(numKeys * 10);
        for (int i = 0; i < numKeys * 10; ++i) {
            this.keys.add("key" + this.nextIntGaussian(numKeys));
        }
    }

    private int nextIntGaussian(int numKeys) {
        double gaussian = RANDOM.nextGaussian();
        if (gaussian < -3.0 || gaussian > 3.0) {
            return this.nextIntGaussian(numKeys);
        }
        return (int)Math.abs((gaussian + 3.0) * (double)numKeys / 6.0);
    }

    private void waitForStart() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Operation<String, Integer> readOperation(AbstractDelegatingStore store) {
        return new Operation<String, Integer>(store, "GET"){

            @Override
            public boolean call(String key, long run) {
                try {
                    InternalCacheEntry ice = this.store.load((Object)key);
                    if (trace) {
                        log.tracef("Loaded key=%s, value=%s", (Object)key, ice != null ? ice.getValue() : "null");
                    }
                    return ice != null;
                }
                catch (CacheLoaderException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        };
    }

    private Operation<String, Integer> writeOperation(AbstractDelegatingStore store) {
        return new Operation<String, Integer>(store, "PUT"){

            @Override
            public boolean call(final String key, long run) {
                final int value = (int)run;
                final InternalCacheEntry entry = AsyncStoreStressTest.this.entryFactory.create((Object)key, (Object)value, (EntryVersion)null);
                boolean result = AsyncStoreStressTest.this.withStore(key, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        store.store(entry);
                        AsyncStoreStressTest.this.expectedState.put(key, entry);
                        if (trace) {
                            log.tracef("Expected state updated with key=%s, value=%s", (Object)key, (Object)value);
                        }
                        return true;
                    }
                });
                return result;
            }
        };
    }

    private Operation<String, Integer> removeOperation(AbstractDelegatingStore store) {
        return new Operation<String, Integer>(store, "REMOVE"){

            @Override
            public boolean call(final String key, long run) {
                boolean result = AsyncStoreStressTest.this.withStore(key, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        boolean removed = store.remove((Object)key);
                        if (removed) {
                            AsyncStoreStressTest.this.expectedState.remove(key);
                            if (trace) {
                                log.tracef("Expected state removed key=%s", (Object)key);
                            }
                        }
                        return true;
                    }
                });
                return result;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withStore(String key, Callable<Boolean> call) {
        Lock lock = null;
        boolean result = false;
        try {
            lock = this.locks.acquireLock((Object)Thread.currentThread(), (Object)key, 30L, TimeUnit.SECONDS);
            if (lock != null) {
                result = call.call();
                return result;
            }
        }
        catch (CacheLoaderException e) {
            e.printStackTrace();
            result = false;
            return result;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            result = false;
            return result;
        }
        finally {
            if (lock == null) {
                return false;
            }
            lock.unlock();
            return result;
        }
    }

    private double computeStdDev(AbstractDelegatingStore store, int numKeys) throws CacheLoaderException {
        double variance = 0.0;
        Set keys = store.loadAllKeys(null);
        for (Object key : keys) {
            double value = Integer.parseInt(((String)key).substring(3));
            variance += (value - (double)(numKeys / 2)) * (value - (double)(numKeys / 2));
        }
        return Math.sqrt(variance / (double)keys.size());
    }

    @Test(enabled=false)
    public static void main(String[] args) throws Exception {
        AsyncStoreStressTest test = new AsyncStoreStressTest();
        test.testReadWriteRemove(100000, 300000, 90, 9, 1);
        test.testReadWriteRemove(10000, 30000, 9, 1, 0);
        System.exit(0);
    }

    private static class OpStats {
        public final String opName;
        public final int threadCount;
        public final long opCount;
        public final long runningTime;
        public final long missCount;

        private OpStats(String opName, long opCount, long runningTime, long missCount) {
            this.opName = opName;
            this.threadCount = 1;
            this.opCount = opCount;
            this.runningTime = runningTime;
            this.missCount = missCount;
        }

        private OpStats(OpStats base, long opCount, long runningTime, long missCount) {
            this.opName = base.opName;
            this.threadCount = base.threadCount + 1;
            this.opCount = base.opCount + opCount;
            this.runningTime = base.runningTime + runningTime;
            this.missCount = base.missCount + missCount;
        }
    }

    private static class TotalStats {
        private ConcurrentHashMap<String, OpStats> statsMap = new ConcurrentHashMap();

        private TotalStats() {
        }

        public void addStats(String opName, long opCount, long runningTime, long missCount) {
            boolean replaced;
            OpStats s = new OpStats(opName, opCount, runningTime, missCount);
            OpStats old = this.statsMap.putIfAbsent(opName, s);
            boolean bl = replaced = old == null;
            while (!replaced) {
                old = this.statsMap.get(opName);
                s = new OpStats(old, opCount, runningTime, missCount);
                replaced = this.statsMap.replace(opName, old, s);
            }
        }

        public double getOpsPerSec(String opName) {
            OpStats s = this.statsMap.get(opName);
            if (s == null) {
                return 0.0;
            }
            return (double)s.opCount * 1000.0 / (double)s.runningTime * (double)s.threadCount;
        }

        public double getTotalOpsPerSec() {
            long totalOpCount = 0L;
            long totalRunningTime = 0L;
            long totalThreadCount = 0L;
            for (Map.Entry<String, OpStats> e : this.statsMap.entrySet()) {
                OpStats s = e.getValue();
                totalOpCount += s.opCount;
                totalRunningTime += s.runningTime;
                totalThreadCount += (long)s.threadCount;
            }
            return (double)totalOpCount * 1000.0 / (double)totalRunningTime * (double)totalThreadCount;
        }

        public double getHitRatio(String opName) {
            OpStats s = this.statsMap.get(opName);
            if (s == null) {
                return 0.0;
            }
            return 1.0 - 1.0 * (double)s.missCount / (double)s.opCount;
        }

        public double getTotalHitRatio() {
            long totalOpCount = 0L;
            long totalMissCount = 0L;
            for (Map.Entry<String, OpStats> e : this.statsMap.entrySet()) {
                OpStats s = e.getValue();
                totalOpCount += s.opCount;
                totalMissCount += s.missCount;
            }
            return 1.0 - 1.0 * (double)totalMissCount / (double)totalOpCount;
        }
    }

    private static abstract class Operation<K, V> {
        protected final AbstractDelegatingStore store;
        protected final String name;

        public Operation(AbstractDelegatingStore store, String name) {
            this.store = store;
            this.name = name;
        }

        public abstract boolean call(K var1, long var2);

        public String getName() {
            return this.name;
        }
    }

    private class WorkerThread
    extends Thread {
        private final long runningTimeout;
        private final TotalStats perf;
        private Operation<String, Integer> op;

        public WorkerThread(String name, long runningTimeout, TotalStats perf, Operation<String, Integer> op) {
            super(name);
            this.runningTimeout = runningTimeout;
            this.perf = perf;
            this.op = op;
        }

        @Override
        public void run() {
            AsyncStoreStressTest.this.waitForStart();
            long startMilis = System.currentTimeMillis();
            long endMillis = startMilis + this.runningTimeout;
            int keyIndex = RANDOM.nextInt(AsyncStoreStressTest.this.keys.size());
            long runs = 0L;
            long missCount = 0L;
            while ((runs & 0x3FFFL) != 0L || System.currentTimeMillis() < endMillis) {
                boolean hit = this.op.call((String)AsyncStoreStressTest.this.keys.get(keyIndex), runs);
                if (!hit) {
                    ++missCount;
                }
                ++runs;
                if (++keyIndex < AsyncStoreStressTest.this.keys.size()) continue;
                keyIndex = 0;
            }
            this.perf.addStats(this.op.getName(), runs, System.currentTimeMillis() - startMilis, missCount);
        }
    }
}

