/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.BoundedConcurrentHashMap;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="stress.MapStressTest", groups={"stress"}, enabled=false, description="Disabled by default, designed to be run manually.")
public class MapStressTest {
    static final float MAP_LOAD_FACTOR = 0.75f;
    static final int LOOP_FACTOR = 10;
    static final long RUNNING_TIME = Integer.getInteger("time", 1) * 60 * 1000;
    final int CAPACITY = Integer.getInteger("size", 100000);
    private static final Random RANDOM = new Random(12345L);
    private volatile CountDownLatch latch;
    private List<String> keys = new ArrayList<String>();

    public MapStressTest() {
        System.out.printf("\nMapStressTest configuration: capacity %d, test running time %d seconds\n", this.CAPACITY, RUNNING_TIME / 1000L);
    }

    private void generateKeyList(int numKeys) {
        this.keys = null;
        this.keys = new ArrayList<String>(numKeys * 10);
        for (int i = 0; i < numKeys * 10; ++i) {
            this.keys.add("key" + this.nextIntGaussian(numKeys));
        }
    }

    private int nextIntGaussian(int numKeys) {
        double gaussian = RANDOM.nextGaussian();
        if (gaussian < -3.0 || gaussian > 3.0) {
            return this.nextIntGaussian(numKeys);
        }
        return (int)Math.abs((gaussian + 3.0) * (double)numKeys / 6.0);
    }

    private Map<String, Integer> synchronizedLinkedHashMap(final int capacity, float loadFactor) {
        return Collections.synchronizedMap(new LinkedHashMap<String, Integer>(capacity, loadFactor, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
                return this.size() > capacity;
            }
        });
    }

    private Cache<String, Integer> configureAndBuildCache(int capacity) {
        Configuration config = new Configuration().fluent().eviction().maxEntries(Integer.valueOf(capacity)).strategy(EvictionStrategy.LRU).expiration().wakeUpInterval(Long.valueOf(5000L)).maxIdle(Long.valueOf(120000L)).build();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getNonClusteredDefault(), config);
        cm.start();
        return cm.getCache();
    }

    @DataProvider(name="readWriteRemove")
    public Object[][] independentReadWriteRemoveParams() {
        return new Object[][]{{this.CAPACITY, 3 * this.CAPACITY, 32, 90, 9, 1}, {this.CAPACITY, 3 * this.CAPACITY, 32, 9, 1, 0}};
    }

    @DataProvider(name="readWriteRatio")
    public Object[][] readWriteRatioParams() {
        return new Object[][]{{this.CAPACITY, 3 * this.CAPACITY, 32, 100, 9}, {this.CAPACITY, 3 * this.CAPACITY, 32, 10, 9}};
    }

    @DataProvider(name="writeOnMiss")
    public Object[][] writeOnMissParams() {
        return new Object[][]{{this.CAPACITY, 3 * this.CAPACITY, 32, 100}, {this.CAPACITY, 3 * this.CAPACITY, 32, 10}};
    }

    private Map<String, Map<String, Integer>> createMaps(int capacity, int numKeys, int concurrency) {
        TreeMap<String, Map<String, Integer>> maps = new TreeMap<String, Map<String, Integer>>();
        maps.put("BCHM:LRU", (Map<String, Integer>)new BoundedConcurrentHashMap(capacity, concurrency, BoundedConcurrentHashMap.Eviction.LRU));
        maps.put("BCHM:LIRS", (Map<String, Integer>)new BoundedConcurrentHashMap(capacity, concurrency, BoundedConcurrentHashMap.Eviction.LIRS));
        maps.put("CHM", new ConcurrentHashMap(numKeys, 0.75f, concurrency));
        maps.put("SLHM", this.synchronizedLinkedHashMap(capacity, 0.75f));
        maps.put("CACHE", (Map<String, Integer>)this.configureAndBuildCache(capacity));
        return maps;
    }

    @Test(dataProvider="readWriteRemove", enabled=false)
    public void testReadWriteRemove(int capacity, int numKeys, int concurrency, int readerThreads, int writerThreads, int removerThreads) throws Exception {
        System.out.printf("Testing independent read/write/remove performance with capacity %d, keys %d, concurrency level %d, readers %d, writers %d, removers %d\n", capacity, numKeys, concurrency, readerThreads, writerThreads, removerThreads);
        this.generateKeyList(numKeys);
        Map<String, Map<String, Integer>> maps = this.createMaps(capacity, numKeys, concurrency);
        for (Map.Entry<String, Map<String, Integer>> e : maps.entrySet()) {
            this.mapTestReadWriteRemove(e.getKey(), e.getValue(), numKeys, readerThreads, writerThreads, removerThreads);
            e.setValue(null);
        }
    }

    private void mapTestReadWriteRemove(String name, Map<String, Integer> map, int numKeys, int readerThreads, int writerThreads, int removerThreads) throws Exception {
        this.runMapTestReadWriteRemove(map, readerThreads, writerThreads, removerThreads, 1000L);
        TotalStats perf = this.runMapTestReadWriteRemove(map, readerThreads, writerThreads, removerThreads, RUNNING_TIME);
        System.out.printf("Container %-12s  ", name);
        System.out.printf("Ops/s %10.2f  ", perf.getTotalOpsPerSec());
        System.out.printf("Gets/s %10.2f  ", perf.getOpsPerSec("GET"));
        System.out.printf("Puts/s %10.2f  ", perf.getOpsPerSec("PUT"));
        System.out.printf("Removes/s %10.2f  ", perf.getOpsPerSec("REMOVE"));
        System.out.printf("HitRatio %10.2f  ", perf.getTotalHitRatio() * 100.0);
        System.out.printf("Size %10d  ", map.size());
        double stdDev = this.computeStdDev(map, numKeys);
        System.out.printf("StdDev %10.2f\n", stdDev);
    }

    private TotalStats runMapTestReadWriteRemove(Map<String, Integer> map, int numReaders, int numWriters, int numRemovers, long runningTimeout) throws Exception {
        int i;
        this.latch = new CountDownLatch(1);
        TotalStats perf = new TotalStats();
        LinkedList<WorkerThread> threads = new LinkedList<WorkerThread>();
        for (i = 0; i < numReaders; ++i) {
            WorkerThread workerThread = new WorkerThread(runningTimeout, perf, this.readOperation(map));
            threads.add(workerThread);
        }
        for (i = 0; i < numWriters; ++i) {
            WorkerThread workerThread = new WorkerThread(runningTimeout, perf, this.writeOperation(map));
            threads.add(workerThread);
        }
        for (i = 0; i < numRemovers; ++i) {
            WorkerThread workerThread = new WorkerThread(runningTimeout, perf, this.removeOperation(map));
            threads.add(workerThread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        this.latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        return perf;
    }

    @Test(dataProvider="readWriteRatio", enabled=false)
    public void testMixedReadWrite(int capacity, int numKeys, int concurrency, int threads, int readToWriteRatio) throws Exception {
        System.out.printf("Testing mixed read/write performance with capacity %d, keys %d, concurrency level %d, threads %d, read:write ratio %d:1\n", capacity, numKeys, concurrency, threads, readToWriteRatio);
        this.generateKeyList(numKeys);
        Map<String, Map<String, Integer>> maps = this.createMaps(capacity, numKeys, concurrency);
        for (Map.Entry<String, Map<String, Integer>> e : maps.entrySet()) {
            this.mapTestMixedReadWrite(e.getKey(), e.getValue(), numKeys, threads, readToWriteRatio);
            e.setValue(null);
        }
    }

    private void mapTestMixedReadWrite(String name, Map<String, Integer> map, int numKeys, int threads, int readToWriteRatio) throws Exception {
        this.runMapTestMixedReadWrite(map, threads, readToWriteRatio, 1000L);
        TotalStats perf = this.runMapTestMixedReadWrite(map, threads, readToWriteRatio, RUNNING_TIME);
        System.out.printf("Container %-12s  ", name);
        System.out.printf("Ops/s %10.2f  ", perf.getTotalOpsPerSec());
        System.out.printf("Gets/s %10.2f  ", perf.getTotalOpsPerSec() * (double)readToWriteRatio / (double)(readToWriteRatio + 1));
        System.out.printf("Puts/s %10.2f  ", perf.getTotalOpsPerSec() * 1.0 / (double)(readToWriteRatio + 1));
        System.out.printf("HitRatio %10.2f  ", perf.getTotalHitRatio() * 100.0);
        System.out.printf("Size %10d  ", map.size());
        double stdDev = this.computeStdDev(map, numKeys);
        System.out.printf("stdDev %10.2f\n", stdDev);
    }

    private TotalStats runMapTestMixedReadWrite(Map<String, Integer> map, int numThreads, int readToWriteRatio, long runningTimeout) throws Exception {
        this.latch = new CountDownLatch(1);
        TotalStats perf = new TotalStats();
        LinkedList<WorkerThread> threads = new LinkedList<WorkerThread>();
        for (int i = 0; i < numThreads; ++i) {
            WorkerThread workerThread = new WorkerThread(runningTimeout, perf, this.readWriteOperation(map, readToWriteRatio));
            threads.add(workerThread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        this.latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        return perf;
    }

    @Test(dataProvider="writeOnMiss", enabled=false)
    public void testWriteOnMiss(int capacity, int numKeys, int concurrency, int threads) throws Exception {
        System.out.printf("Testing write on miss performance with capacity %d, keys %d, concurrency level %d, threads %d\n", capacity, numKeys, concurrency, threads);
        this.generateKeyList(numKeys);
        Map<String, Map<String, Integer>> maps = this.createMaps(capacity, numKeys, concurrency);
        for (Map.Entry<String, Map<String, Integer>> e : maps.entrySet()) {
            this.mapTestWriteOnMiss(e.getKey(), e.getValue(), numKeys, threads);
            e.setValue(null);
        }
    }

    private void mapTestWriteOnMiss(String name, Map<String, Integer> map, int numKeys, int threads) throws Exception {
        this.runMapTestWriteOnMiss(map, threads, 1000L);
        TotalStats perf = this.runMapTestWriteOnMiss(map, threads, RUNNING_TIME);
        System.out.printf("Container %-12s  ", name);
        System.out.printf("Ops/s %10.2f  ", perf.getTotalOpsPerSec());
        System.out.printf("HitRatio %10.2f  ", perf.getTotalHitRatio() * 100.0);
        System.out.printf("Size %10d  ", map.size());
        double stdDev = this.computeStdDev(map, numKeys);
        System.out.printf("stdDev %10.2f\n", stdDev);
    }

    private TotalStats runMapTestWriteOnMiss(Map<String, Integer> map, int numThreads, long runningTimeout) throws Exception {
        this.latch = new CountDownLatch(1);
        TotalStats perf = new TotalStats();
        LinkedList<WorkerThread> threads = new LinkedList<WorkerThread>();
        for (int i = 0; i < numThreads; ++i) {
            WorkerThread workerThread = new WorkerThread(runningTimeout, perf, this.writeOnMissOperation(map));
            threads.add(workerThread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        this.latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        return perf;
    }

    private double computeStdDev(Map<String, Integer> map, int numKeys) {
        double variance = 0.0;
        for (String key : map.keySet()) {
            double value = Integer.parseInt(key.substring(3));
            variance += (value - (double)(numKeys / 2)) * (value - (double)(numKeys / 2));
        }
        return Math.sqrt(variance / (double)map.size());
    }

    private void waitForStart() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Operation<String, Integer> readOperation(Map<String, Integer> map) {
        return new Operation<String, Integer>(map, "GET"){

            @Override
            public boolean call(String key, long run) {
                return this.map.get(key) != null;
            }
        };
    }

    private Operation<String, Integer> writeOperation(Map<String, Integer> map) {
        return new Operation<String, Integer>(map, "PUT"){

            @Override
            public boolean call(String key, long run) {
                return this.map.put(key, (int)run) != null;
            }
        };
    }

    private Operation<String, Integer> removeOperation(Map<String, Integer> map) {
        return new Operation<String, Integer>(map, "REMOVE"){

            @Override
            public boolean call(String key, long run) {
                return this.map.remove(key) != null;
            }
        };
    }

    private Operation<String, Integer> readWriteOperation(Map<String, Integer> map, final int readToWriteRatio) {
        return new Operation<String, Integer>(map, "READ/WRITE:" + readToWriteRatio + "/1"){

            @Override
            public boolean call(String key, long run) {
                if (run % (long)(readToWriteRatio + 1) == 0L) {
                    return this.map.put(key, (int)run) != null;
                }
                return this.map.get(key) != null;
            }
        };
    }

    private Operation<String, Integer> writeOnMissOperation(Map<String, Integer> map) {
        return new Operation<String, Integer>(map, "PUTMISSING"){

            @Override
            public boolean call(String key, long run) {
                boolean hit;
                boolean bl = hit = this.map.get(key) != null;
                if (!hit) {
                    this.map.put(key, (int)run);
                }
                return hit;
            }
        };
    }

    private static class OpStats {
        public final String opName;
        public final int threadCount;
        public final long opCount;
        public final long runningTime;
        public final long missCount;

        private OpStats(String opName, long opCount, long runningTime, long missCount) {
            this.opName = opName;
            this.threadCount = 1;
            this.opCount = opCount;
            this.runningTime = runningTime;
            this.missCount = missCount;
        }

        private OpStats(OpStats base, long opCount, long runningTime, long missCount) {
            this.opName = base.opName;
            this.threadCount = base.threadCount + 1;
            this.opCount = base.opCount + opCount;
            this.runningTime = base.runningTime + runningTime;
            this.missCount = base.missCount + missCount;
        }
    }

    private static class TotalStats {
        private ConcurrentHashMap<String, OpStats> statsMap = new ConcurrentHashMap();

        private TotalStats() {
        }

        public void addStats(String opName, long opCount, long runningTime, long missCount) {
            boolean replaced;
            OpStats s = new OpStats(opName, opCount, runningTime, missCount);
            OpStats old = this.statsMap.putIfAbsent(opName, s);
            boolean bl = replaced = old == null;
            while (!replaced) {
                old = this.statsMap.get(opName);
                s = new OpStats(old, opCount, runningTime, missCount);
                replaced = this.statsMap.replace(opName, old, s);
            }
        }

        public double getOpsPerSec(String opName) {
            OpStats s = this.statsMap.get(opName);
            if (s == null) {
                return 0.0;
            }
            return (double)s.opCount * 1000.0 / (double)s.runningTime * (double)s.threadCount;
        }

        public double getTotalOpsPerSec() {
            long totalOpCount = 0L;
            long totalRunningTime = 0L;
            long totalThreadCount = 0L;
            for (Map.Entry<String, OpStats> e : this.statsMap.entrySet()) {
                OpStats s = e.getValue();
                totalOpCount += s.opCount;
                totalRunningTime += s.runningTime;
                totalThreadCount += (long)s.threadCount;
            }
            return (double)totalOpCount * 1000.0 / (double)totalRunningTime * (double)totalThreadCount;
        }

        public double getHitRatio(String opName) {
            OpStats s = this.statsMap.get(opName);
            if (s == null) {
                return 0.0;
            }
            return 1.0 - 1.0 * (double)s.missCount / (double)s.opCount;
        }

        public double getTotalHitRatio() {
            long totalOpCount = 0L;
            long totalMissCount = 0L;
            for (Map.Entry<String, OpStats> e : this.statsMap.entrySet()) {
                OpStats s = e.getValue();
                totalOpCount += s.opCount;
                totalMissCount += s.missCount;
            }
            return 1.0 - 1.0 * (double)totalMissCount / (double)totalOpCount;
        }
    }

    private static abstract class Operation<K, V> {
        protected final Map<K, V> map;
        protected final String name;

        public Operation(Map<K, V> map, String name) {
            this.map = map;
            this.name = name;
        }

        public abstract boolean call(K var1, long var2);

        public String getName() {
            return this.name;
        }
    }

    private class WorkerThread
    extends Thread {
        private final long runningTimeout;
        private final TotalStats perf;
        private Operation<String, Integer> op;

        public WorkerThread(long runningTimeout, TotalStats perf, Operation<String, Integer> op) {
            this.runningTimeout = runningTimeout;
            this.perf = perf;
            this.op = op;
        }

        @Override
        public void run() {
            MapStressTest.this.waitForStart();
            long startMilis = System.currentTimeMillis();
            long endMillis = startMilis + this.runningTimeout;
            int keyIndex = RANDOM.nextInt(MapStressTest.this.keys.size());
            long runs = 0L;
            long missCount = 0L;
            while ((runs & 0x3FFFL) != 0L || System.currentTimeMillis() < endMillis) {
                boolean hit = this.op.call((String)MapStressTest.this.keys.get(keyIndex), runs);
                if (!hit) {
                    ++missCount;
                }
                ++runs;
                if (++keyIndex < MapStressTest.this.keys.size()) continue;
                keyIndex = 0;
            }
            this.perf.addStats(this.op.getName(), runs, System.currentTimeMillis() - startMilis, missCount);
        }
    }
}

