/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.TransactionManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterTest;

public class AbstractInfinispanTest {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Set<Thread> spawnedThreads = new HashSet<Thread>();
    private final AtomicInteger spawnedThreadsCounter = new AtomicInteger(0);

    @AfterTest(alwaysRun=true)
    protected void killSpawnedThreads() {
        for (Thread t : this.spawnedThreads) {
            if (!t.isAlive()) continue;
            t.interrupt();
        }
    }

    protected void eventually(Condition ec, long timeout) {
        this.eventually(ec, timeout, 10);
    }

    protected void eventually(Condition ec, long timeout, int loops) {
        if (loops <= 0) {
            throw new IllegalArgumentException("Number of loops must be positive");
        }
        long sleepDuration = timeout / (long)loops;
        if (sleepDuration == 0L) {
            sleepDuration = 1L;
        }
        try {
            for (int i = 0; i < loops && !ec.isSatisfied(); ++i) {
                Thread.sleep(sleepDuration);
            }
            Assert.assertTrue((boolean)ec.isSatisfied());
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    protected Thread fork(Runnable r, boolean waitForCompletion) {
        String name = "ForkThread-" + this.spawnedThreadsCounter.incrementAndGet() + "," + this.getClass().getSimpleName();
        this.log.tracef("About to start thread '%s' as child of thread '%s'", (Object)name, (Object)Thread.currentThread().getName());
        final Thread t = new Thread((Runnable)new RunnableWrapper(r), name);
        this.spawnedThreads.add(t);
        t.start();
        if (waitForCompletion) {
            this.eventually(new Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return t.getState().equals((Object)Thread.State.TERMINATED);
                }
            });
        }
        return t;
    }

    protected <T> Future<T> fork(Runnable r, T result) {
        String name = "ForkThread-" + this.spawnedThreadsCounter.incrementAndGet() + "," + this.getClass().getSimpleName();
        this.log.tracef("About to start thread '%s' as child of thread '%s'", (Object)name, (Object)Thread.currentThread().getName());
        FutureTask<T> future = new FutureTask<T>(r, result);
        Thread t = new Thread(future, name);
        this.spawnedThreads.add(t);
        t.start();
        return future;
    }

    protected <T> Future<T> fork(Callable<T> c) {
        String name = "ForkThread-" + this.spawnedThreadsCounter.incrementAndGet() + "," + this.getClass().getSimpleName();
        this.log.tracef("About to start thread '%s' as child of thread '%s'", (Object)name, (Object)Thread.currentThread().getName());
        FutureTask<T> future = new FutureTask<T>(c);
        Thread t = new Thread(future, name);
        this.spawnedThreads.add(t);
        t.start();
        return future;
    }

    protected ThreadFactory getTestThreadFactory(final String prefix) {
        final String className = this.getClass().getSimpleName();
        return new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                String threadName = prefix + "-" + this.counter.incrementAndGet() + "," + className;
                return new Thread(r, threadName);
            }
        };
    }

    protected void eventually(Condition ec) {
        this.eventually(ec, 10000L);
    }

    public static void safeRollback(TransactionManager transactionManager) {
        try {
            transactionManager.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static interface Condition {
        public boolean isSatisfied() throws Exception;
    }

    public final class RunnableWrapper
    implements Runnable {
        final Runnable realOne;

        public RunnableWrapper(Runnable realOne) {
            this.realOne = realOne;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractInfinispanTest.this.log.trace((Object)"Started fork thread..");
                this.realOne.run();
            }
            catch (Throwable e) {
                AbstractInfinispanTest.this.log.trace((Object)"Exiting fork thread due to exception", e);
            }
            finally {
                AbstractInfinispanTest.this.log.trace((Object)"Exiting fork thread.");
            }
        }
    }
}

