/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.Immutables;
import org.infinispan.util.LegacyKeySupportSystemProperties;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;

public class JGroupsConfigBuilder {
    public static final String JGROUPS_STACK;
    private static final ProtocolStackConfigurator tcpConfigurator;
    private static final ProtocolStackConfigurator udpConfigurator;
    public static final int TCP_PORT_RANGE_PER_THREAD = 100;
    private static final ThreadLocal<Integer> threadTcpStartPort;
    private static final ThreadLocal<String> threadMcastIP;
    private static final ThreadLocal<Integer> threadMcastPort;

    public static String getJGroupsConfig(String fullTestName, TransportFlags flags) {
        if (JGROUPS_STACK.equalsIgnoreCase("tcp")) {
            return JGroupsConfigBuilder.getTcpConfig(fullTestName, flags);
        }
        if (JGROUPS_STACK.equalsIgnoreCase("udp")) {
            return JGroupsConfigBuilder.getUdpConfig(fullTestName, flags);
        }
        throw new IllegalStateException("Unknown protocol stack : " + JGROUPS_STACK);
    }

    public static String getTcpConfig(String fullTestName, TransportFlags flags) {
        JGroupsProtocolCfg jgroupsCfg = JGroupsConfigBuilder.getJGroupsProtocolCfg(tcpConfigurator.getProtocolStack());
        if (!flags.withFD()) {
            JGroupsConfigBuilder.removeFailureDetectionTcp(jgroupsCfg);
        }
        if (!flags.isSiteIndexSpecified()) {
            JGroupsConfigBuilder.removeRela2(jgroupsCfg);
        } else {
            ProtocolConfiguration protocol = jgroupsCfg.getProtocol(ProtocolType.RELAY2);
            protocol.getProperties().put("site", flags.siteName());
            if (flags.relayConfig() != null) {
                protocol.getProperties().put("config", flags.relayConfig());
            }
        }
        if (!flags.withMerge()) {
            JGroupsConfigBuilder.removeMerge(jgroupsCfg);
        }
        if (jgroupsCfg.containsProtocol(ProtocolType.TEST_PING)) {
            JGroupsConfigBuilder.replaceTcpStartPort(jgroupsCfg, flags);
            if (fullTestName == null) {
                return jgroupsCfg.toString();
            }
            return JGroupsConfigBuilder.getTestPingDiscovery(fullTestName, jgroupsCfg);
        }
        return JGroupsConfigBuilder.replaceMCastAddressAndPort(jgroupsCfg);
    }

    private static void removeMerge(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.MERGE2);
    }

    public static String getUdpConfig(String fullTestName, TransportFlags flags) {
        JGroupsProtocolCfg jgroupsCfg = JGroupsConfigBuilder.getJGroupsProtocolCfg(udpConfigurator.getProtocolStack());
        if (!flags.withFD()) {
            JGroupsConfigBuilder.removeFailureDetectionUdp(jgroupsCfg);
        }
        if (!flags.withMerge()) {
            JGroupsConfigBuilder.removeMerge(jgroupsCfg);
        }
        if (!flags.isSiteIndexSpecified()) {
            JGroupsConfigBuilder.removeRela2(jgroupsCfg);
        }
        if (jgroupsCfg.containsProtocol(ProtocolType.TEST_PING) && fullTestName != null) {
            return JGroupsConfigBuilder.getTestPingDiscovery(fullTestName, jgroupsCfg);
        }
        return JGroupsConfigBuilder.replaceMCastAddressAndPort(jgroupsCfg);
    }

    private static void removeFailureDetectionTcp(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.FD).removeProtocol(ProtocolType.VERIFY_SUSPECT);
    }

    private static void removeRela2(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.RELAY2);
    }

    private static String getTestPingDiscovery(String fullTestName, JGroupsProtocolCfg jgroupsCfg) {
        ProtocolType type = ProtocolType.TEST_PING;
        Map props = jgroupsCfg.getProtocol(type).getProperties();
        props.put("testName", fullTestName);
        return JGroupsConfigBuilder.replaceProperties(jgroupsCfg, props, type);
    }

    private static void removeFailureDetectionUdp(JGroupsProtocolCfg jgroupsCfg) {
        jgroupsCfg.removeProtocol(ProtocolType.FD_SOCK).removeProtocol(ProtocolType.FD_ALL);
    }

    private static String replaceMCastAddressAndPort(JGroupsProtocolCfg jgroupsCfg) {
        Map props = jgroupsCfg.getProtocol(ProtocolType.UDP).getProperties();
        props.put("mcast_addr", threadMcastIP.get());
        props.put("mcast_port", threadMcastPort.get().toString());
        return JGroupsConfigBuilder.replaceProperties(jgroupsCfg, props, ProtocolType.UDP);
    }

    private static String replaceTcpStartPort(JGroupsProtocolCfg jgroupsCfg, TransportFlags transportFlags) {
        Map props = jgroupsCfg.getProtocol(ProtocolType.TCP).getProperties();
        Integer startPort = threadTcpStartPort.get();
        int portRange = 100;
        if (transportFlags.isSiteIndexSpecified()) {
            portRange = 10;
            int maxIndex = 100 / portRange - 1;
            if (transportFlags.siteIndex() > maxIndex) {
                throw new IllegalStateException("Currently we only support " + (maxIndex + 1) + " sites!");
            }
            startPort = startPort + transportFlags.siteIndex() * portRange;
        }
        props.put("bind_port", startPort.toString());
        props.put("port_range", String.valueOf(portRange - 1));
        return JGroupsConfigBuilder.replaceProperties(jgroupsCfg, props, ProtocolType.TCP);
    }

    private static String replaceProperties(JGroupsProtocolCfg cfg, Map<String, String> newProps, ProtocolType type) {
        ProtocolConfiguration protocol = cfg.getProtocol(type);
        ProtocolConfiguration newProtocol = new ProtocolConfiguration(protocol.getProtocolName(), newProps);
        cfg.replaceProtocol(type, newProtocol);
        return cfg.toString();
    }

    private static ProtocolStackConfigurator loadTcp() {
        try {
            return ConfiguratorFactory.getStackConfigurator((String)"stacks/tcp.xml");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ProtocolStackConfigurator loadUdp() {
        try {
            return ConfiguratorFactory.getStackConfigurator((String)"stacks/udp.xml");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JGroupsProtocolCfg getJGroupsProtocolCfg(List<ProtocolConfiguration> baseStack) {
        JGroupsXmxlConfigurator configurator = new JGroupsXmxlConfigurator(baseStack);
        List protoStack = configurator.getProtocolStack();
        HashMap<ProtocolType, ProtocolConfiguration> protoMap = new HashMap<ProtocolType, ProtocolConfiguration>(protoStack.size());
        for (ProtocolConfiguration cfg : protoStack) {
            protoMap.put(JGroupsConfigBuilder.getProtocolType(cfg.getProtocolName()), cfg);
        }
        return new JGroupsProtocolCfg(protoMap, (ProtocolStackConfigurator)configurator);
    }

    private static ProtocolType getProtocolType(String name) {
        int dotIndex = name.lastIndexOf(".");
        return ProtocolType.valueOf(dotIndex == -1 ? name : name.substring(dotIndex + 1, name.length()));
    }

    static {
        tcpConfigurator = JGroupsConfigBuilder.loadTcp();
        udpConfigurator = JGroupsConfigBuilder.loadUdp();
        threadTcpStartPort = new ThreadLocal<Integer>(){
            private final AtomicInteger uniqueAddr = new AtomicInteger(7900);

            @Override
            protected Integer initialValue() {
                return this.uniqueAddr.getAndAdd(100);
            }
        };
        threadMcastIP = new ThreadLocal<String>(){
            private final AtomicInteger uniqueAddr = new AtomicInteger(11);

            @Override
            protected String initialValue() {
                return "228.10.10." + this.uniqueAddr.getAndIncrement();
            }
        };
        threadMcastPort = new ThreadLocal<Integer>(){
            private final AtomicInteger uniquePort = new AtomicInteger(45589);

            @Override
            protected Integer initialValue() {
                return this.uniquePort.getAndIncrement();
            }
        };
        JGROUPS_STACK = LegacyKeySupportSystemProperties.getProperty((String)"infinispan.test.jgroups.protocol", (String)"protocol.stack", (String)"tcp");
        System.out.println("Transport protocol stack used = " + JGROUPS_STACK);
    }

    static enum ProtocolType {
        TCP,
        UDP,
        MPING,
        PING,
        TCPPING,
        TEST_PING,
        MERGE2,
        FD_SOCK,
        FD,
        VERIFY_SUSPECT,
        FD_ALL,
        BARRIER,
        NAKACK,
        UNICAST,
        NAKACK2,
        UNICAST2,
        RSVP,
        STABLE,
        GMS,
        UFC,
        MFC,
        FC,
        FRAG2,
        STREAMING_STATE_TRANSFER,
        RELAY2;

    }

    static class JGroupsProtocolCfg {
        final Map<ProtocolType, ProtocolConfiguration> protoMap;
        final ProtocolStackConfigurator configurator;

        JGroupsProtocolCfg(Map<ProtocolType, ProtocolConfiguration> protoMap, ProtocolStackConfigurator configurator) {
            this.protoMap = protoMap;
            this.configurator = configurator;
        }

        JGroupsProtocolCfg addProtocol(ProtocolType type, ProtocolConfiguration cfg, int position) {
            this.protoMap.put(type, cfg);
            this.configurator.getProtocolStack().add(position, cfg);
            return this;
        }

        JGroupsProtocolCfg removeProtocol(ProtocolType type) {
            this.configurator.getProtocolStack().remove(this.protoMap.remove((Object)type));
            return this;
        }

        ProtocolConfiguration getProtocol(ProtocolType type) {
            return this.protoMap.get((Object)type);
        }

        boolean containsProtocol(ProtocolType type) {
            return this.getProtocol(type) != null;
        }

        JGroupsProtocolCfg replaceProtocol(ProtocolType type, ProtocolConfiguration newCfg) {
            ProtocolConfiguration oldCfg = this.protoMap.get((Object)type);
            int position = this.configurator.getProtocolStack().indexOf(oldCfg);
            return this.removeProtocol(type).addProtocol(type, newCfg, position);
        }

        public String toString() {
            return this.configurator.getProtocolStackString();
        }
    }

    static class JGroupsXmxlConfigurator
    extends XmlConfigurator {
        protected JGroupsXmxlConfigurator(List<ProtocolConfiguration> protocols) {
            super(JGroupsXmxlConfigurator.copy(protocols));
        }

        static List<ProtocolConfiguration> copy(List<ProtocolConfiguration> protocols) {
            ArrayList<ProtocolConfiguration> copy = new ArrayList<ProtocolConfiguration>(protocols.size());
            for (ProtocolConfiguration p : protocols) {
                copy.add(new ProtocolConfiguration(p.getProtocolName(), Immutables.immutableMapCopy((Map)p.getProperties())));
            }
            return copy;
        }
    }
}

