/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.IClass;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.xml.XmlClass;

public class UnitTestTestNGListener
implements ITestListener,
IInvokedMethodListener {
    private ThreadLocal<IClass> threadTestClass = new ThreadLocal();
    private static final Log log = LogFactory.getLog(UnitTestTestNGListener.class);
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger succeeded = new AtomicInteger(0);
    private AtomicInteger skipped = new AtomicInteger(0);
    private AtomicBoolean oomHandled = new AtomicBoolean();

    public void onTestStart(ITestResult res) {
        log.info((Object)("Starting test " + this.getTestDesc(res)));
        this.addOomLoggingSupport();
        this.threadTestClass.set(res.getTestClass());
    }

    private void addOomLoggingSupport() {
        final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void uncaughtException(Thread t, Throwable e) {
                try {
                    if (e instanceof OutOfMemoryError && UnitTestTestNGListener.this.oomHandled.compareAndSet(false, true)) {
                        UnitTestTestNGListener.this.printAllTheThreadsInTheJvm();
                    }
                }
                finally {
                    if (oldHandler != null) {
                        oldHandler.uncaughtException(t, e);
                    }
                }
            }
        });
    }

    public synchronized void onTestSuccess(ITestResult arg0) {
        String message = "Test " + this.getTestDesc(arg0) + " succeeded.";
        System.out.println(this.getThreadId() + ' ' + message);
        log.info((Object)message);
        this.succeeded.incrementAndGet();
        this.printStatus();
    }

    public synchronized void onTestFailure(ITestResult arg0) {
        String message = "Test " + this.getTestDesc(arg0) + " failed.";
        System.out.println(this.getThreadId() + ' ' + message);
        log.error((Object)message, arg0.getThrowable());
        this.failed.incrementAndGet();
        this.printStatus();
    }

    public synchronized void onTestSkipped(ITestResult arg0) {
        String message = "Test " + this.getTestDesc(arg0) + " skipped.";
        System.out.println(this.getThreadId() + ' ' + message);
        log.error((Object)message, arg0.getThrowable());
        this.skipped.incrementAndGet();
        this.printStatus();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onStart(ITestContext arg0) {
        String fullName = arg0.getName();
        String simpleName = fullName.substring(fullName.lastIndexOf(46) + 1);
        Class testClass = ((XmlClass)arg0.getCurrentXmlTest().getXmlClasses().get(0)).getSupportClass();
        boolean isAbstract = Modifier.isAbstract(testClass.getModifiers());
        if (!isAbstract && !simpleName.equals(testClass.getSimpleName())) {
            log.warnf("Wrong test name %s for class %s", (Object)simpleName, (Object)testClass.getSimpleName());
        }
        TestCacheManagerFactory.testStarted(testClass.getSimpleName(), testClass.getName());
    }

    public void onFinish(ITestContext arg0) {
        Class testClass = ((XmlClass)arg0.getCurrentXmlTest().getXmlClasses().get(0)).getSupportClass();
        TestCacheManagerFactory.testFinished(testClass.getSimpleName());
    }

    private String getThreadId() {
        return "[" + Thread.currentThread().getName() + "]";
    }

    private String getTestDesc(ITestResult res) {
        return res.getMethod().getMethodName() + "(" + res.getTestClass().getName() + ")";
    }

    private void printStatus() {
        String message = "Test suite progress: tests succeeded: " + this.succeeded.get() + ", failed: " + this.failed.get() + ", skipped: " + this.skipped.get() + ".";
        System.out.println(message);
        log.info((Object)message);
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (testResult.getThrowable() != null && method.isConfigurationMethod()) {
            String message = String.format("Configuration method %s threw an exception", this.getTestDesc(testResult));
            System.out.println(message);
            log.error((Object)message, testResult.getThrowable());
        }
    }

    private void printAllTheThreadsInTheJvm() {
        if (log.isTraceEnabled()) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            log.tracef("Dumping all %s threads in the system.", (Object)allStackTraces.size());
            for (Map.Entry<Thread, StackTraceElement[]> s : allStackTraces.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Thread: ").append(s.getKey().getName()).append(". Stack trace:\n");
                for (StackTraceElement ste : s.getValue()) {
                    sb.append("      ").append(ste.toString()).append("\n");
                }
                log.trace((Object)sb.toString());
            }
        }
    }
}

