/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.DefaultEnlistmentModeTest")
public class DefaultEnlistmentModeTest
extends AbstractCacheTest {
    private DefaultCacheManager dcm;

    @AfterMethod
    protected void destroyCacheManager() {
        TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{this.dcm});
    }

    public void testDefaultEnlistment() {
        ConfigurationBuilder builder = this.getLocalBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.dcm = new DefaultCacheManager(this.getGlobalConfig(), builder.build());
        Cache cache = this.dcm.getCache();
        Assert.assertTrue((boolean)cache.getCacheConfiguration().transaction().useSynchronization());
        cache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
    }

    public void testXAEnlistment() {
        ConfigurationBuilder builder = this.getLocalBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(false);
        this.dcm = new DefaultCacheManager(this.getGlobalConfig(), builder.build());
        Cache cache = this.dcm.getCache();
        Assert.assertFalse((boolean)cache.getCacheConfiguration().transaction().useSynchronization());
        Assert.assertTrue((boolean)cache.getCacheConfiguration().transaction().recovery().enabled());
        cache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
    }

    public void testXAEnlistmentNoRecovery() {
        ConfigurationBuilder builder = this.getLocalBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(false).recovery().disable();
        this.dcm = new DefaultCacheManager(this.getGlobalConfig(), builder.build());
        Cache cache = this.dcm.getCache();
        Assert.assertFalse((boolean)cache.getCacheConfiguration().transaction().useSynchronization());
        Assert.assertFalse((boolean)cache.getCacheConfiguration().transaction().recovery().enabled());
    }

    private ConfigurationBuilder getLocalBuilder() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        return builder;
    }

    private GlobalConfiguration getGlobalConfig() {
        return new GlobalConfigurationBuilder().globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true)).build();
    }
}

