/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.DummyTxTest")
public class DummyTxTest
extends SingleCacheManagerTest {
    protected final Log log = LogFactory.getLog(this.getClass());

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().invocationBatching().enable().versioning().enable().scheme(VersioningScheme.SIMPLE).locking().lockAcquisitionTimeout(200L).writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ);
        cm.defineConfiguration("test", cb.build());
        this.cache = cm.getCache("test");
        return cm;
    }

    public void testConcurrentRemove() throws Exception {
        this.runConcurrentRemove(false);
    }

    public void testConcurrentConditionalRemove() throws Exception {
        this.runConcurrentRemove(true);
    }

    private void runConcurrentRemove(final boolean useConditionalRemove) throws Exception {
        this.cache.put((Object)"k1", (Object)"v1");
        int numThreads = 5;
        final AtomicInteger removed = new AtomicInteger();
        final AtomicInteger rolledBack = new AtomicInteger();
        final AtomicInteger didNothing = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        Thread[] threads = new Thread[5];
        for (int i = 0; i < 5; ++i) {
            threads[i] = new Thread("DummyTxTest.Remover-" + i){

                @Override
                public void run() {
                    try {
                        latch.await();
                        DummyTxTest.this.tm().begin();
                        try {
                            boolean success = useConditionalRemove ? DummyTxTest.this.cache.remove((Object)"k1", (Object)"v1") : DummyTxTest.this.cache.remove((Object)"k1") != null;
                            DummyTxTest.this.log.trace((Object)("Remove call success: " + success));
                            TestingUtil.sleepRandom(200);
                            DummyTxTest.this.tm().commit();
                            if (success) {
                                removed.incrementAndGet();
                            } else {
                                didNothing.incrementAndGet();
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof RollbackException) {
                                rolledBack.incrementAndGet();
                            } else if (DummyTxTest.this.tm().getTransaction() != null) {
                                try {
                                    DummyTxTest.this.tm().rollback();
                                    rolledBack.incrementAndGet();
                                }
                                catch (SystemException e1) {
                                    DummyTxTest.this.log.error((Object)"Failed to rollback", (Throwable)e1);
                                }
                            }
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        DummyTxTest.this.log.error((Object)e);
                    }
                }
            };
            threads[i].start();
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        this.log.trace((Object)("removed= " + removed.get()));
        this.log.trace((Object)("rolledBack= " + rolledBack.get()));
        this.log.trace((Object)("didNothing= " + didNothing.get()));
        AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)"k1"));
        AssertJUnit.assertEquals((int)1, (int)removed.get());
        AssertJUnit.assertEquals((int)4, (int)(rolledBack.get() + didNothing.get()));
    }
}

