/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.LockCleanupStateTransferTest")
@CleanupAfterMethod
public class LockCleanupStateTransferTest
extends MultipleCacheManagersTest {
    private static final int KEY_SET_SIZE = 10;
    private ConfigurationBuilder dcc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dcc = LockCleanupStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.dcc.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.dcc.clustering().hash().numOwners(1);
        this.dcc.clustering().stateTransfer().fetchInMemoryState(true);
        this.createCluster(this.dcc, 2);
        this.waitForClusterToForm();
    }

    public void testBelatedCommit() throws Throwable {
        this.testLockReleasedCorrectly(CommitCommand.class);
    }

    public void testBelatedTxCompletionNotificationCommand() throws Throwable {
        this.testLockReleasedCorrectly(TxCompletionNotificationCommand.class);
    }

    private void testLockReleasedCorrectly(Class<? extends ReplicableCommand> toBlock) throws Throwable {
        final ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.advancedCache(1), toBlock);
        ccf.gate.close();
        final HashSet keys = new HashSet(10);
        Future<Object> future = this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LockCleanupStateTransferTest.this.tm(0).begin();
                for (int i = 0; i < 10; ++i) {
                    Object k = LockCleanupStateTransferTest.this.getKeyForCache(1);
                    keys.add(k);
                    LockCleanupStateTransferTest.this.cache(0).put(k, k);
                }
                LockCleanupStateTransferTest.this.tm(0).commit();
                return null;
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                LockCleanupStateTransferTest.this.log.tracef("receivedCommands == %s", (Object)ccf.blockTypeCommandsReceived.get());
                return ccf.blockTypeCommandsReceived.get() == 1;
            }
        });
        if (toBlock == TxCompletionNotificationCommand.class) {
            DataContainer dc = this.advancedCache(1).getDataContainer();
            for (Object k : keys) {
                Assert.assertEquals(k, (Object)dc.get(k).getValue());
            }
        }
        this.log.trace((Object)"Before state transfer");
        this.addClusterEnabledCacheManager(this.dcc);
        this.waitForClusterToForm();
        this.log.trace((Object)"After state transfer");
        HashSet migratedKeys = new HashSet(10);
        for (Object key : keys) {
            if (!this.keyMapsToNode(key, 2)) continue;
            migratedKeys.add(key);
        }
        this.log.tracef("Number of migrated keys is %s", (Object)migratedKeys.size());
        if (migratedKeys.size() == 0) {
            return;
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                int remoteTxCount = TestingUtil.getTransactionTable((Cache<Object, Object>)LockCleanupStateTransferTest.this.cache(2)).getRemoteTxCount();
                LockCleanupStateTransferTest.this.log.tracef("remoteTxCount=%s", (Object)remoteTxCount);
                return remoteTxCount == 1;
            }
        });
        this.log.trace((Object)"Releasing the gate");
        ccf.gate.open();
        future.get(10L, TimeUnit.SECONDS);
        for (int i = 0; i < 3; ++i) {
            TransactionTable tt = TestingUtil.getTransactionTable(this.cache(i));
            Assert.assertEquals((String)("For cache " + i), (long)0L, (long)tt.getLocalTxCount());
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                boolean success = true;
                for (int i = 0; i < 3; ++i) {
                    TransactionTable tt = TestingUtil.getTransactionTable((Cache<Object, Object>)LockCleanupStateTransferTest.this.cache(i));
                    int remoteTxCount = tt.getRemoteTxCount();
                    LockCleanupStateTransferTest.this.log.tracef("For cache %s, remoteTxCount==%d", (Object)LockCleanupStateTransferTest.this.cache(i), (Object)remoteTxCount);
                    success &= remoteTxCount == 0;
                }
                return success;
            }
        });
        for (Object key : keys) {
            this.assertNotLocked(key);
            Assert.assertEquals(key, (Object)this.cache(0).get(key));
        }
        for (Object k : migratedKeys) {
            Assert.assertFalse((boolean)this.advancedCache(0).getDataContainer().containsKey(k));
            Assert.assertFalse((boolean)this.advancedCache(1).getDataContainer().containsKey(k));
            Assert.assertTrue((boolean)this.advancedCache(2).getDataContainer().containsKey(k));
        }
    }

    private boolean keyMapsToNode(Object key, int nodeIndex) {
        Address owner = this.owner(key);
        return owner.equals(this.address(nodeIndex));
    }

    private Address owner(Object key) {
        return (Address)this.advancedCache(0).getDistributionManager().getConsistentHash().locateOwners(key).get(0);
    }
}

