/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.AbstractControlledRpcManager;
import org.infinispan.util.concurrent.ReclosableLatch;

public class ControlledRpcManager
extends AbstractControlledRpcManager {
    private final ReclosableLatch replicationLatch = new ReclosableLatch(true);
    private final ReclosableLatch blockingLatch = new ReclosableLatch(true);
    private volatile Set<Class> blockBeforeFilter = Collections.emptySet();
    private volatile Set<Class> blockAfterFilter = Collections.emptySet();
    private volatile Set<Class> failFilter = Collections.emptySet();

    public ControlledRpcManager(RpcManager realOne) {
        super(realOne);
    }

    public void failFor(Class ... filter) {
        this.failFilter = new HashSet<Class>(Arrays.asList(filter));
        this.blockingLatch.open();
    }

    public void stopFailing() {
        this.failFilter = Collections.emptySet();
        this.blockingLatch.open();
    }

    public void blockBefore(Class ... filter) {
        this.blockBeforeFilter = new HashSet<Class>(Arrays.asList(filter));
        this.replicationLatch.close();
        this.blockingLatch.close();
    }

    public void blockAfter(Class ... filter) {
        this.blockAfterFilter = new HashSet<Class>(Arrays.asList(filter));
        this.replicationLatch.close();
        this.blockingLatch.close();
    }

    public void stopBlocking() {
        this.log.tracef("Stop blocking commands", new Object[0]);
        this.blockBeforeFilter = Collections.emptySet();
        this.blockAfterFilter = Collections.emptySet();
        this.replicationLatch.open();
    }

    public void waitForCommandToBlock() throws InterruptedException {
        this.log.tracef("Waiting for at least one command to block", new Object[0]);
        this.blockingLatch.await();
    }

    public boolean waitForCommandToBlock(long time, TimeUnit unit) throws InterruptedException {
        return this.blockingLatch.await(time, unit);
    }

    public void failIfNeeded(ReplicableCommand rpcCommand) {
        if (this.failFilter.contains(this.getActualClass(rpcCommand))) {
            throw new IllegalStateException("Induced failure!");
        }
    }

    protected void waitBefore(ReplicableCommand rpcCommand) {
        this.waitForReplicationLatch(rpcCommand, this.blockBeforeFilter);
    }

    protected void waitAfter(ReplicableCommand rpcCommand) {
        this.waitForReplicationLatch(rpcCommand, this.blockAfterFilter);
    }

    protected void waitForReplicationLatch(ReplicableCommand rpcCommand, Set<Class> filter) {
        Class cmdClass = this.getActualClass(rpcCommand);
        if (!filter.contains(cmdClass)) {
            return;
        }
        try {
            this.blockingLatch.open();
            this.log.debugf("Replication trigger called, waiting for latch to open.", new Object[0]);
            this.replicationLatch.await();
            this.log.trace((Object)"Replication latch opened, continuing.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception!", e);
        }
    }

    private Class getActualClass(ReplicableCommand rpcCommand) {
        Class<?> cmdClass = rpcCommand.getClass();
        if (cmdClass.equals(SingleRpcCommand.class)) {
            cmdClass = ((SingleRpcCommand)rpcCommand).getCommand().getClass();
        }
        return cmdClass;
    }

    @Override
    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    @Override
    public Address getAddress() {
        return this.realOne.getAddress();
    }

    @Override
    public int getTopologyId() {
        return this.realOne.getTopologyId();
    }

    @Override
    protected void beforeInvokeRemotely(ReplicableCommand command) {
        this.failIfNeeded(command);
        this.waitBefore(command);
    }

    @Override
    protected Map<Address, Response> afterInvokeRemotely(ReplicableCommand command, Map<Address, Response> responseMap) {
        this.waitAfter(command);
        return responseMap;
    }
}

