/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.PerCacheExecutorThread;
import org.infinispan.test.TestingUtil;
import org.infinispan.tx.dld.BaseDldPessimisticLockingTest;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.dld.DldPessimisticLockingReplicationTest")
public class DldPessimisticLockingReplicationTest
extends BaseDldPessimisticLockingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = this.getConfiguration();
        this.createClusteredCaches(2, configuration);
        TestingUtil.blockUntilViewsReceived(1000L, this.cache(0), this.cache(1));
    }

    protected Configuration getConfiguration() throws Exception {
        Configuration configuration = DldPessimisticLockingReplicationTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        configuration.setUseEagerLocking(true);
        configuration.setEnableDeadlockDetection(true);
        configuration.setUseLockStriping(false);
        return configuration;
    }

    public void testDeadlock() throws Exception {
        this.testSymmetricDld("k1", "k2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeadlockFailedToAcquireLocalLocks() throws Exception {
        this.tm(0).begin();
        this.cache(0).getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"k1", (Object)"v1");
        assert (this.lm0.isLocked((Object)"k1"));
        assert (!this.lm1.isLocked((Object)"k1"));
        try {
            this.ex0.execute(PerCacheExecutorThread.Operations.BEGIN_TX);
            this.ex0.setKeyValue("k1", "v1_1");
            this.ex0.execute(PerCacheExecutorThread.Operations.PUT_KEY_VALUE);
            assert (this.ex0.lastResponse() instanceof TimeoutException) : "received " + this.ex0.lastResponse();
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return !DldPessimisticLockingReplicationTest.this.lm1.isLocked((Object)"k1");
                }
            });
        }
        finally {
            this.tm(0).rollback();
        }
    }
}

