/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import java.util.HashMap;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TxAndRemoteTimeoutExceptionTest")
public class TxAndRemoteTimeoutExceptionTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(TxAndRemoteTimeoutExceptionTest.class);
    private LockManager lm1;
    private LockManager lm0;
    private TransactionTable txTable0;
    private TransactionTable txTable1;
    private TransactionManager tm;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration defaultConfig = this.getDefaultConfig();
        defaultConfig.setLockAcquisitionTimeout(500L);
        defaultConfig.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        defaultConfig.setUseLockStriping(false);
        this.addClusterEnabledCacheManager(defaultConfig);
        this.addClusterEnabledCacheManager(defaultConfig);
        this.lm0 = TestingUtil.extractLockManager(this.cache(0));
        this.lm1 = TestingUtil.extractLockManager(this.cache(1));
        this.txTable0 = TestingUtil.getTransactionTable(this.cache(0));
        this.txTable1 = TestingUtil.getTransactionTable(this.cache(1));
        this.tm = this.cache(0).getAdvancedCache().getTransactionManager();
        TestingUtil.blockUntilViewReceived(this.cache(0), 2);
    }

    protected Configuration getDefaultConfig() {
        return TxAndRemoteTimeoutExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
    }

    public void testClearTimeoutsInTx() throws Exception {
        this.cache(0).put((Object)"k1", (Object)"value");
        this.runAssertion(new CacheOperation(){

            @Override
            public void execute() {
                TxAndRemoteTimeoutExceptionTest.this.cache(0).clear();
            }
        });
    }

    public void testPutTimeoutsInTx() throws Exception {
        this.runAssertion(new CacheOperation(){

            @Override
            public void execute() {
                TxAndRemoteTimeoutExceptionTest.this.cache(0).put((Object)"k1", (Object)"v2222");
            }
        });
    }

    public void testRemoveTimeoutsInTx() throws Exception {
        this.runAssertion(new CacheOperation(){

            @Override
            public void execute() {
                TxAndRemoteTimeoutExceptionTest.this.cache(0).remove((Object)"k1");
            }
        });
    }

    public void testReplaceTimeoutsInTx() throws Exception {
        this.cache(1).put((Object)"k1", (Object)"value");
        this.runAssertion(new CacheOperation(){

            @Override
            public void execute() {
                TxAndRemoteTimeoutExceptionTest.this.cache(0).replace((Object)"k1", (Object)"newValue");
            }
        });
    }

    public void testPutAllTimeoutsInTx() throws Exception {
        this.runAssertion(new CacheOperation(){

            @Override
            public void execute() {
                HashMap<String, String> toAdd = new HashMap<String, String>();
                toAdd.put("k1", "v22222");
                TxAndRemoteTimeoutExceptionTest.this.cache(0).putAll(toAdd);
            }
        });
    }

    private void runAssertion(CacheOperation operation) throws NotSupportedException, SystemException, HeuristicMixedException, HeuristicRollbackException, InvalidTransactionException, RollbackException {
        this.tm.begin();
        this.cache(1).put((Object)"k1", (Object)"v1");
        DummyTransaction k1LockOwner = (DummyTransaction)this.tm.suspend();
        assert (!this.lm1.isLocked((Object)"k1"));
        Assert.assertEquals((int)1, (int)this.txTable1.getLocalTxCount());
        this.tm.begin();
        this.cache(0).put((Object)"k2", (Object)"v2");
        assert (!this.lm0.isLocked((Object)"k2"));
        assert (!this.lm1.isLocked((Object)"k2"));
        operation.execute();
        Assert.assertEquals((int)1, (int)this.txTable1.getLocalTxCount());
        Assert.assertEquals((int)1, (int)this.txTable0.getLocalTxCount());
        Transaction tx2 = this.tm.suspend();
        this.tm.resume((Transaction)k1LockOwner);
        k1LockOwner.runPrepare();
        this.tm.suspend();
        this.tm.resume(tx2);
        try {
            this.tm.commit();
            assert (false);
        }
        catch (RollbackException re) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)this.txTable0.getLocalTxCount());
        Assert.assertEquals((int)1, (int)this.txTable1.getLocalTxCount());
        log.trace((Object)"Right before second commit");
        this.tm.resume((Transaction)k1LockOwner);
        this.tm.commit();
        Assert.assertEquals((Object)"v1", (Object)this.cache(0).get((Object)"k1"));
        Assert.assertEquals((Object)"v1", (Object)this.cache(1).get((Object)"k1"));
        Assert.assertEquals((int)0, (int)this.txTable1.getLocalTxCount());
        Assert.assertEquals((int)0, (int)this.txTable1.getLocalTxCount());
        this.assertNotLocked("k1");
        this.assertNotLocked("k2");
    }

    public static interface CacheOperation {
        public void execute();
    }
}

