/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import java.util.Collections;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.SystemException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractClusteredTxTest
extends MultipleCacheManagersTest {
    Object k;

    public void testPut() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v");
        this.assertLocking();
    }

    public void testRemove() throws Exception {
        this.tm(0).begin();
        this.cache(0).remove(this.k);
        this.assertLocking();
    }

    public void testReplace() throws Exception {
        this.tm(0).begin();
        this.cache(0).replace(this.k, (Object)"v1");
        this.assertLockingNoChanges();
        this.cache(0).put(this.k, (Object)"v1");
        this.tm(0).begin();
        this.cache(0).replace(this.k, (Object)"v2");
        this.assertLocking();
    }

    public void testClear() throws Exception {
        this.cache(0).put(this.k, (Object)"v");
        this.tm(0).begin();
        this.cache(0).clear();
        this.assertLocking();
    }

    public void testPutAll() throws Exception {
        Map<Object, String> m = Collections.singletonMap(this.k, "v");
        this.tm(0).begin();
        this.cache(0).putAll(m);
        this.assertLocking();
    }

    public void testRollbackOnPrimaryOwner() throws Exception {
        this.testRollback(0);
    }

    public void testRollbackOnBackupOwner() throws Exception {
        this.testRollback(1);
    }

    private void testRollback(int executeOn) throws Exception {
        this.tm(executeOn).begin();
        this.cache(executeOn).put(this.k, (Object)"v");
        this.assertLockingOnRollback();
        this.assertNoTransactions();
        Assert.assertNull((Object)this.cache(0).get(this.k));
        Assert.assertNull((Object)this.cache(1).get(this.k));
    }

    protected void commit() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm(0);
        try {
            dtm.getTransaction().runCommitTx();
        }
        catch (HeuristicMixedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepare() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm(0);
        try {
            dtm.getTransaction().runPrepare();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected void rollback() {
        DummyTransactionManager dtm = (DummyTransactionManager)this.tm(0);
        try {
            dtm.getTransaction().rollback();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void assertLocking();

    protected abstract void assertLockingNoChanges();

    protected abstract void assertLockingOnRollback();
}

