/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.tx.locking.AbstractLocalTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.LocalOptimisticTxTest")
public class LocalOptimisticTxTest
extends AbstractLocalTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration config = this.getDefaultStandaloneConfig(true);
        config.fluent().transaction().lockingMode(LockingMode.OPTIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        return TestCacheManagerFactory.createCacheManager(config);
    }

    @Override
    protected void assertLockingOnRollback() {
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
        this.rollback();
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }

    @Override
    protected void assertLocking() {
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
        this.prepare();
        Assert.assertTrue((boolean)this.lockManager().isLocked((Object)"k"));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager().isLocked((Object)"k"));
    }
}

