/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.RemoteException;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.tx.locking.AbstractClusteredTxTest;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.PessimisticReplTxTest")
public class PessimisticReplTxTest
extends AbstractClusteredTxTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder conf = this.buildConfiguration();
        this.createCluster(conf, 2);
        this.waitForClusterToForm();
        System.out.println("PessimisticReplTxTest.createCacheManagers");
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder conf = PessimisticReplTxTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        conf.transaction().lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).locking().lockAcquisitionTimeout(10L);
        return conf;
    }

    public PessimisticReplTxTest() {
        this.k = "k";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTxInProgress1() throws Exception {
        this.log.info((Object)"test :: start");
        try {
            this.test(0, 0);
        }
        finally {
            this.log.info((Object)"test :: end");
        }
    }

    public void testTxInProgress2() throws Exception {
        this.test(0, 1);
    }

    public void testTxInProgress3() throws Exception {
        this.test(1, 1);
    }

    public void testTxInProgress4() throws Exception {
        this.test(1, 0);
    }

    public void testLockingInterfaceOnPrimaryOwner() throws Exception {
        this.testLockingWithRollback(0);
    }

    public void testLockingInterfaceOnBackupOwner() throws Exception {
        this.testLockingWithRollback(1);
    }

    private void testLockingWithRollback(int executeOn) throws Exception {
        this.tm(executeOn).begin();
        this.advancedCache(executeOn).lock(new Object[]{this.k});
        this.assertLockingOnRollback();
        this.assertNoTransactions();
        Assert.assertNull((Object)this.cache(0).get(this.k));
        Assert.assertNull((Object)this.cache(1).get(this.k));
        this.tm(executeOn).begin();
        this.advancedCache(executeOn).lock(new Object[]{this.k});
        this.cache(executeOn).put(this.k, (Object)"v");
        this.assertLockingOnRollback();
        this.assertNoTransactions();
        Assert.assertNull((Object)this.cache(0).get(this.k));
        Assert.assertNull((Object)this.cache(1).get(this.k));
    }

    private void test(int firstTxIndex, int secondTxIndex) throws Exception {
        this.tm(firstTxIndex).begin();
        this.cache(firstTxIndex).put(this.k, (Object)"v1");
        Transaction tx1 = this.tm(firstTxIndex).suspend();
        this.tm(secondTxIndex).begin();
        try {
            this.cache(secondTxIndex).put(this.k, (Object)"v2");
            assert (false) : "Exception expected";
        }
        catch (TimeoutException e) {
            this.tm(secondTxIndex).suspend();
        }
        catch (RemoteException e) {
            assert (e.getCause() instanceof TimeoutException);
            this.tm(secondTxIndex).suspend();
        }
        this.tm(firstTxIndex).resume(tx1);
        this.tm(firstTxIndex).commit();
        assert (this.cache(0).get(this.k).equals("v1"));
        this.log.info((Object)"Before get...");
        this.assertNotLocked(this.k);
        assert (this.cache(1).get(this.k).equals("v1"));
        this.assertNotLocked(this.k);
    }

    public void simpleTest() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v");
        this.tm(0).commit();
        Assert.assertEquals((Object)this.cache(0).get(this.k), (Object)"v");
        Assert.assertEquals((Object)this.cache(1).get(this.k), (Object)"v");
    }

    @Override
    protected void assertLocking() {
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.prepare();
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }

    @Override
    protected void assertLockingNoChanges() {
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.prepare();
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }

    @Override
    protected void assertLockingOnRollback() {
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.rollback();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }
}

