/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tx.recovery.RecoveryWithDefaultCacheDistTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.RecoveryWithCustomCacheDistTest")
public class RecoveryWithCustomCacheDistTest
extends RecoveryWithDefaultCacheDistTest {
    private static final String CUSTOM_CACHE = "customCache";
    private Configuration recoveryCache;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configuration = super.configure();
        this.configuration.fluent().transaction().recovery().recoveryInfoCacheName(CUSTOM_CACHE);
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createClusteredCacheManager(this.configuration)});
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createClusteredCacheManager(this.configuration)});
        this.recoveryCache = RecoveryWithCustomCacheDistTest.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL);
        this.recoveryCache.fluent().transaction().transactionManagerLookupClass(null);
        this.recoveryCache.fluent().transaction().recovery().disable();
        this.manager(0).defineConfiguration(CUSTOM_CACHE, this.recoveryCache);
        this.manager(1).defineConfiguration(CUSTOM_CACHE, this.recoveryCache);
        this.manager(0).startCaches(new String[]{"___defaultcache", CUSTOM_CACHE});
        this.manager(1).startCaches(new String[]{"___defaultcache", CUSTOM_CACHE});
        this.waitForClusterToForm(CUSTOM_CACHE);
        assert (this.manager(0).getCacheNames().contains(CUSTOM_CACHE));
        assert (this.manager(1).getCacheNames().contains(CUSTOM_CACHE));
    }

    @Override
    protected String getRecoveryCacheName() {
        return CUSTOM_CACHE;
    }

    @Override
    protected void defineRecoveryCache(int cacheManagerIndex) {
        this.manager(1).defineConfiguration(CUSTOM_CACHE, this.recoveryCache);
    }
}

