/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;

public abstract class AbstractRecoveryTest
extends MultipleCacheManagersTest {
    protected Configuration defaultRecoveryConfig() {
        return AbstractRecoveryTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true).fluent().transaction().transactionManagerLookupClass(RecoveryDummyTransactionManagerLookup.class).recovery().locking().useLockStriping(Boolean.valueOf(false)).clustering().hash().numOwners(Integer.valueOf(2)).rehashEnabled(Boolean.valueOf(false)).clustering().l1().disable().stateRetrieval().fetchInMemoryState(Boolean.valueOf(false)).build();
    }

    protected int countInDoubtTx(String inDoubt) {
        int lastIndex = 0;
        int count = 0;
        while ((lastIndex = inDoubt.indexOf("internalId", lastIndex + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    protected RecoveryAdminOperations recoveryOps(int cacheIndex) {
        return (RecoveryAdminOperations)this.advancedCache(cacheIndex).getComponentRegistry().getComponent(RecoveryAdminOperations.class);
    }

    protected List<Long> getInternalIds(String inDoubt) {
        Pattern p = Pattern.compile("internalId = [0-9]*");
        Matcher matcher = p.matcher(inDoubt);
        ArrayList<Long> result = new ArrayList<Long>();
        while (matcher.find()) {
            String group = matcher.group();
            Long id = Long.parseLong(group.substring("internalId = ".length()));
            result.add(id);
        }
        return result;
    }

    protected boolean isSuccess(String result) {
        return result.contains("successful");
    }

    public RecoveryAwareTransactionTable tt(int index) {
        return (RecoveryAwareTransactionTable)this.advancedCache(index).getComponentRegistry().getComponent(TransactionTable.class);
    }

    protected void checkProperlyCleanup(final int managerIndex) {
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return TestingUtil.extractLockManager(AbstractRecoveryTest.this.cache(managerIndex)).getNumberOfLocksHeld() == 0;
            }
        });
        final TransactionTable tt = TestingUtil.extractComponent(this.cache(managerIndex), TransactionTable.class);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                AbstractRecoveryTest.this.log.tracef("For cache %s have remoteTx=%s and localTx=%s", (Object)managerIndex, (Object)tt.getRemoteTxCount(), (Object)tt.getLocalTxCount());
                return tt.getRemoteTxCount() == 0 && tt.getLocalTxCount() == 0;
            }
        });
        final RecoveryManager rm = TestingUtil.extractComponent(this.cache(managerIndex), RecoveryManager.class);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return rm.getInDoubtTransactions().isEmpty() && rm.getPreparedTransactionsFromCluster().all().length == 0;
            }
        });
    }

    protected void assertCleanup(int ... caches) {
        for (int i : caches) {
            this.checkProperlyCleanup(i);
        }
    }

    protected RecoveryManagerImpl recoveryManager(int cacheIndex) {
        return (RecoveryManagerImpl)TestingUtil.extractComponent(this.cache(cacheIndex), RecoveryManager.class);
    }

    protected int getTxParticipant(boolean txParticipant) {
        int expectedNumber = txParticipant ? 1 : 0;
        int index = -1;
        for (int i = 0; i < 2; ++i) {
            if (this.recoveryManager(i).getInDoubtTransactionsMap().size() != expectedNumber) continue;
            index = i;
            break;
        }
        return index;
    }
}

