/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.OriginatorAndOwnerFailureTest")
@CleanupAfterMethod
public class OriginatorAndOwnerFailureTest
extends AbstractRecoveryTest {
    private Object key;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = this.defaultRecoveryConfig();
        assert (configuration.isTransactionalCache());
        this.createCluster(configuration, 3);
        this.waitForClusterToForm();
        this.key = this.getKey();
        this.tm(2).begin();
        this.cache(2).put(this.key, (Object)"newValue");
        DummyTransaction tx = (DummyTransaction)this.tm(2).suspend();
        RecoveryTestUtil.prepareTransaction(tx);
        this.killMember(2);
        assert (!this.recoveryOps(0).showInDoubtTransactions().isEmpty());
        assert (!this.recoveryOps(1).showInDoubtTransactions().isEmpty());
    }

    protected Object getKey() {
        return new MagicKey(this.cache(2));
    }

    public void recoveryInvokedOnNonTxParticipantTest() {
        this.runTest(false);
    }

    public void recoveryInvokedOnTxParticipantTest() {
        this.runTest(true);
    }

    private void runTest(boolean txParticipant) {
        int index = this.getTxParticipant(txParticipant);
        this.runTest(index);
    }

    protected void runTest(int index) {
        assert (this.cache(0).getConfiguration().isTransactionalCache());
        List<Long> internalIds = this.getInternalIds(this.recoveryOps(index).showInDoubtTransactions());
        Assert.assertEquals((int)internalIds.size(), (int)1);
        Assert.assertEquals((Object)this.cache(0).get(this.key), null);
        Assert.assertEquals((Object)this.cache(1).get(this.key), null);
        this.log.trace((Object)"About to force commit!");
        this.isSuccess(this.recoveryOps(index).forceCommit(internalIds.get(0).longValue()));
        Assert.assertEquals((Object)this.cache(0).get(this.key), (Object)"newValue");
        Assert.assertEquals((Object)this.cache(1).get(this.key), (Object)"newValue");
        this.assertCleanup(0);
        this.assertCleanup(1);
    }
}

