/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractControlledRpcManager
implements RpcManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final RpcManager realOne;

    public AbstractControlledRpcManager(RpcManager realOne) {
        this.realOne = realOne;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotely1");
        this.beforeInvokeRemotely(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
        return this.afterInvokeRemotely(rpcCommand, responseMap);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotely2");
        this.beforeInvokeRemotely(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue);
        return this.afterInvokeRemotely(rpcCommand, responseMap);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotely3");
        this.beforeInvokeRemotely(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout);
        return this.afterInvokeRemotely(rpcCommand, responseMap);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean sync) throws RpcException {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotely4");
        this.beforeInvokeRemotely(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, sync);
        return this.afterInvokeRemotely(rpcCommand, responseMap);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean sync, boolean usePriorityQueue) throws RpcException {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotely5");
        this.beforeInvokeRemotely(rpcCommand);
        Map responses = this.realOne.invokeRemotely(recipients, rpcCommand, sync, usePriorityQueue);
        return this.afterInvokeRemotely(rpcCommand, responses);
    }

    public void broadcastRpcCommand(ReplicableCommand rpcCommand, boolean sync) throws RpcException {
        this.log.trace((Object)"ControlledRpcManager.broadcastRpcCommand1");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.broadcastRpcCommand(rpcCommand, sync);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void broadcastRpcCommand(ReplicableCommand rpcCommand, boolean sync, boolean usePriorityQueue) throws RpcException {
        this.log.trace((Object)"ControlledRpcManager.broadcastRpcCommand2");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.broadcastRpcCommand(rpcCommand, sync, usePriorityQueue);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpcCommand, NotifyingNotifiableFuture<Object> future) {
        this.log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture1");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.broadcastRpcCommandInFuture(rpcCommand, future);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        this.log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture2");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.broadcastRpcCommandInFuture(rpcCommand, usePriorityQueue, future);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, NotifyingNotifiableFuture<Object> future) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture1");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, future);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture2");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, usePriorityQueue, future);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture3");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, usePriorityQueue, future, timeout);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout, boolean ignoreLeavers) {
        this.log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture4");
        this.beforeInvokeRemotely(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, usePriorityQueue, future, timeout, ignoreLeavers);
        this.afterInvokeRemotely(rpcCommand, null);
    }

    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    public Address getAddress() {
        return this.realOne.getAddress();
    }

    public int getTopologyId() {
        return this.realOne.getTopologyId();
    }

    public List<Address> getMembers() {
        return this.realOne.getMembers();
    }

    protected void beforeInvokeRemotely(ReplicableCommand command) {
    }

    protected Map<Address, Response> afterInvokeRemotely(ReplicableCommand command, Map<Address, Response> responseMap) {
        return responseMap;
    }
}

