/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.AbstractControlledRpcManager;

public class CountingRpcManager
extends AbstractControlledRpcManager {
    public volatile int lockCount;
    public volatile int clusterGet;
    public volatile int otherCount;

    public CountingRpcManager(RpcManager realOne) {
        super(realOne);
    }

    public static CountingRpcManager replaceRpcManager(Cache c) {
        AdvancedCache advancedCache = c.getAdvancedCache();
        CountingRpcManager crm = new CountingRpcManager(advancedCache.getRpcManager());
        advancedCache.getComponentRegistry().registerComponent((Object)crm, RpcManager.class);
        advancedCache.getComponentRegistry().rewire();
        assert (advancedCache.getRpcManager().equals(crm));
        return crm;
    }

    public void resetStats() {
        this.lockCount = 0;
        this.clusterGet = 0;
        this.otherCount = 0;
    }

    @Override
    protected void beforeInvokeRemotely(ReplicableCommand rpcCommand) {
        if (rpcCommand instanceof LockControlCommand) {
            ++this.lockCount;
        } else if (rpcCommand instanceof ClusteredGetCommand) {
            ++this.clusterGet;
        } else {
            ++this.otherCount;
        }
    }

    @Override
    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    @Override
    public Address getAddress() {
        return this.realOne.getAddress();
    }

    @Override
    public int getTopologyId() {
        return this.realOne.getTopologyId();
    }

    @Override
    public List<Address> getMembers() {
        return this.realOne.getMembers();
    }
}

