/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.util.InfinispanCollections;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="util.InfinispanCollectionsTest")
public class InfinispanCollectionsTest {
    public void testDifferenceNotStored() {
        HashSet<String> store = new HashSet<String>();
        store.add("a");
        store.add("b");
        store.add("c");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        expected.add("d");
        Set notStored = InfinispanCollections.difference(expected, store);
        AssertJUnit.assertEquals((int)1, (int)notStored.size());
        AssertJUnit.assertTrue((boolean)notStored.contains("d"));
        Set notRemoved = InfinispanCollections.difference(store, expected);
        AssertJUnit.assertEquals((int)0, (int)notRemoved.size());
    }

    public void testDifferenceNotRemoved() {
        HashSet<String> store = new HashSet<String>();
        store.add("a");
        store.add("b");
        store.add("c");
        store.add("d");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        Set notStored = InfinispanCollections.difference(expected, store);
        AssertJUnit.assertEquals((int)0, (int)notStored.size());
        Set notRemoved = InfinispanCollections.difference(store, expected);
        AssertJUnit.assertEquals((int)1, (int)notRemoved.size());
        AssertJUnit.assertTrue((boolean)notRemoved.contains("d"));
    }

    public void testDifferenceNotStoreAndNotRemoved() {
        HashSet<String> store = new HashSet<String>();
        store.add("a");
        store.add("b");
        store.add("c");
        store.add("d");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        expected.add("e");
        Set notStored = InfinispanCollections.difference(expected, store);
        AssertJUnit.assertEquals((int)1, (int)notStored.size());
        AssertJUnit.assertTrue((boolean)notStored.contains("e"));
        Set notRemoved = InfinispanCollections.difference(store, expected);
        AssertJUnit.assertEquals((int)1, (int)notRemoved.size());
        AssertJUnit.assertTrue((boolean)notRemoved.contains("d"));
    }

    public void testNoDifference() {
        HashSet<String> store = new HashSet<String>();
        store.add("a");
        store.add("b");
        store.add("c");
        HashSet<String> expected = new HashSet<String>();
        expected.add("a");
        expected.add("b");
        expected.add("c");
        Set notStored = InfinispanCollections.difference(expected, store);
        AssertJUnit.assertEquals((int)0, (int)notStored.size());
        Set notRemoved = InfinispanCollections.difference(store, expected);
        AssertJUnit.assertEquals((int)0, (int)notRemoved.size());
    }

    public void testEmptyCollectionsIteratorsSame() {
        AssertJUnit.assertTrue((InfinispanCollections.emptySet().iterator() == InfinispanCollections.emptySet().iterator() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((InfinispanCollections.emptyMap().keySet().iterator() == InfinispanCollections.emptyMap().keySet().iterator() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((InfinispanCollections.emptyMap().values().iterator() == InfinispanCollections.emptyMap().values().iterator() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((InfinispanCollections.emptyMap().entrySet().iterator() == InfinispanCollections.emptyMap().entrySet().iterator() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((InfinispanCollections.emptyList().iterator() == InfinispanCollections.emptyList().iterator() ? 1 : 0) != 0);
    }
}

