/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;

public abstract class AbstractTwoSitesTest
extends AbstractXSiteTest {
    protected BackupFailurePolicy lonBackupFailurePolicy = BackupFailurePolicy.WARN;
    protected boolean isLonBackupTransactional = false;
    protected BackupConfiguration.BackupStrategy lonBackupStrategy = BackupConfiguration.BackupStrategy.SYNC;
    protected String lonCustomFailurePolicyClass = null;
    protected boolean use2Pc = false;

    @Override
    protected void createSites() {
        GlobalConfigurationBuilder lonGc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        lonGc.site().localSite("LON");
        ConfigurationBuilder lon = this.getLonActiveConfig();
        lon.sites().addBackup().site("NYC").backupFailurePolicy(this.lonBackupFailurePolicy).strategy(this.lonBackupStrategy).failurePolicyClass(this.lonCustomFailurePolicyClass).useTwoPhaseCommit(this.use2Pc).sites().addInUseBackupSite("NYC");
        ConfigurationBuilder nycBackup = AbstractTwoSitesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        nycBackup.sites().backupFor().remoteSite("NYC").defaultRemoteCache();
        GlobalConfigurationBuilder nycGc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        nycGc.site().localSite("NYC");
        ConfigurationBuilder nyc = this.getNycActiveConfig();
        nyc.sites().addBackup().site("LON").strategy(BackupConfiguration.BackupStrategy.SYNC).sites().addInUseBackupSite("LON");
        ConfigurationBuilder lonBackup = AbstractTwoSitesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, this.isLonBackupTransactional);
        lonBackup.sites().backupFor().remoteSite("LON").defaultRemoteCache();
        this.createSite("LON", 2, lonGc, lon);
        this.createSite("NYC", 2, nycGc, nyc);
        this.startCache("LON", "nycBackup", nycBackup);
        this.startCache("NYC", "lonBackup", lonBackup);
        Configuration lonBackupConfig = this.cache("NYC", "lonBackup", 0).getCacheConfiguration();
        AssertJUnit.assertTrue((boolean)lonBackupConfig.sites().backupFor().isBackupFor("LON", "___defaultcache"));
    }

    protected Cache<Object, Object> backup(String site) {
        if (site.equals("LON")) {
            return this.cache("NYC", "lonBackup", 0);
        }
        if (site.equals("NYC")) {
            return this.cache("LON", "nycBackup", 0);
        }
        throw new IllegalArgumentException("No such site: " + site);
    }

    protected String val(String site) {
        return "v_" + site;
    }

    protected String key(String site) {
        return "k_" + site;
    }

    protected abstract ConfigurationBuilder getNycActiveConfig();

    protected abstract ConfigurationBuilder getLonActiveConfig();
}

