/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionTable;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"xsite"})
public abstract class AbstractXSiteTest
extends AbstractCacheTest {
    List<TestSite> sites = new ArrayList<TestSite>();
    private Map<String, Integer> siteName2index = new HashMap<String, Integer>();

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.isCleanupAfterMethod()) {
            this.createSites();
        }
    }

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        if (!this.isCleanupAfterMethod()) {
            this.createSites();
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (!this.isCleanupAfterMethod()) {
            for (TestSite ts : this.sites) {
                TestingUtil.clearContent(ts.cacheManagers);
            }
        } else {
            this.killSites();
        }
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        if (this.cleanupAfterTest()) {
            this.killSites();
        }
    }

    private void killSites() {
        for (TestSite ts : this.sites) {
            TestingUtil.killCacheManagers(ts.cacheManagers);
        }
        this.sites.clear();
        this.siteName2index.clear();
    }

    protected abstract void createSites();

    protected TestSite createSite(String siteName, int numNodes, GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig) {
        TestSite testSite = new TestSite();
        testSite.createClusteredCaches(numNodes, siteName, null, gcb, defaultCacheConfig, new TransportFlags().withSiteIndex(this.sites.size()).withSiteName(siteName));
        this.sites.add(testSite);
        this.siteName2index.put(siteName, this.sites.size() - 1);
        return testSite;
    }

    protected TestSite site(int index) {
        return this.sites.get(index);
    }

    protected TestSite site(String name) {
        return this.sites.get(this.siteName2index.get(name));
    }

    protected <K, V> Cache<K, V> cache(String site, int index) {
        return this.site(site).cache(index);
    }

    protected <K, V> Cache<K, V> cache(String site, String cacheName, int index) {
        return this.site(site).cache(cacheName, index);
    }

    protected void startCache(String siteName, String cacheName, ConfigurationBuilder configurationBuilder) {
        TestSite site = this.site(siteName);
        for (EmbeddedCacheManager ecm : site.cacheManagers) {
            Configuration config = configurationBuilder.build();
            ecm.defineConfiguration(cacheName, config);
        }
        site.waitForClusterToForm(cacheName);
    }

    private boolean isCleanupAfterMethod() {
        return this.getClass().getAnnotation(CleanupAfterMethod.class) != null;
    }

    protected TransactionTable txTable(Cache cache) {
        return (TransactionTable)cache.getAdvancedCache().getComponentRegistry().getComponent(TransactionTable.class);
    }

    public static class TestSite {
        protected List<EmbeddedCacheManager> cacheManagers = new ArrayList<EmbeddedCacheManager>();

        protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String siteName, String cacheName, GlobalConfigurationBuilder gcb, ConfigurationBuilder builder, TransportFlags flags) {
            ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>(numMembersInCluster);
            for (int i = 0; i < numMembersInCluster; ++i) {
                EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(flags, gcb, builder, siteName);
                if (cacheName != null) {
                    cm.defineConfiguration(cacheName, builder.build());
                }
                Cache cache = cacheName == null ? cm.getCache() : cm.getCache(cacheName);
                caches.add(cache);
            }
            this.waitForClusterToForm(cacheName);
            return caches;
        }

        protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags, GlobalConfigurationBuilder gcb, ConfigurationBuilder builder, String siteName) {
            GlobalConfigurationBuilder clone = GlobalConfigurationBuilder.defaultClusteredBuilder();
            Transport transport = clone.transport().getTransport();
            clone.read(gcb.build());
            clone.transport().transport(transport);
            clone.transport().clusterName("ISPN(SITE " + siteName + ")");
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(clone, builder, flags);
            this.cacheManagers.add(cm);
            return cm;
        }

        protected void waitForClusterToForm(String cacheName) {
            List<Cache> caches = this.getCaches(cacheName);
            Cache cache = caches.get(0);
            TestingUtil.blockUntilViewsReceived(10000, caches);
            if (cache.getConfiguration().getCacheMode().isDistributed()) {
                TestingUtil.waitForRehashToComplete(caches);
            }
        }

        private List<Cache> getCaches(String cacheName) {
            ArrayList<Cache> caches = new ArrayList<Cache>();
            for (EmbeddedCacheManager cm : this.cacheManagers) {
                caches.add(cacheName == null ? cm.getCache() : cm.getCache(cacheName));
            }
            return caches;
        }

        public <K, V> Cache<K, V> cache(int index) {
            return this.cacheManagers.get(index).getCache();
        }

        public <K, V> AdvancedCache<K, V> advancedCache(int index) {
            Cache<K, V> cache = this.cache(index);
            return cache.getAdvancedCache();
        }

        public <K, V> Cache<K, V> cache(String cacheName, int index) {
            return this.cacheManagers.get(index).getCache(cacheName);
        }
    }
}

