/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.NonTxAsyncBackupTest")
public class NonTxAsyncBackupTest
extends AbstractTwoSitesTest {
    private BlockingInterceptor blockingInterceptor;

    public NonTxAsyncBackupTest() {
        this.lonBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
    }

    @Override
    protected void createSites() {
        super.createSites();
        this.blockingInterceptor = new BlockingInterceptor();
        this.backup("LON").getAdvancedCache().addInterceptor((CommandInterceptor)this.blockingInterceptor, 1);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return NonTxAsyncBackupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return NonTxAsyncBackupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @BeforeMethod
    void resetBlockingInterceptor() {
        this.blockingInterceptor.reset();
    }

    public void testPut() throws Exception {
        this.cache("LON", 0).put((Object)"k", (Object)"v");
        this.blockingInterceptor.invocationReceivedLatch.await(20000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"v", (Object)this.cache("LON", 0).get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.cache("LON", 1).get((Object)"k"));
        Assert.assertNull((Object)this.backup("LON").get((Object)"k"));
        this.blockingInterceptor.waitingLatch.countDown();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(NonTxAsyncBackupTest.this.backup("LON").get((Object)"k"));
            }
        });
    }

    public void testRemove() throws Exception {
        this.doPutWithDisabledBlockingInterceptor();
        this.cache("LON", 1).remove((Object)"k");
        this.blockingInterceptor.invocationReceivedLatch.await(20000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)this.cache("LON", 0).get((Object)"k"));
        Assert.assertNull((Object)this.cache("LON", 1).get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
        this.blockingInterceptor.waitingLatch.countDown();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return NonTxAsyncBackupTest.this.backup("LON").get((Object)"k") == null;
            }
        });
    }

    public void testClear() throws Exception {
        this.doPutWithDisabledBlockingInterceptor();
        this.cache("LON", 1).clear();
        this.blockingInterceptor.invocationReceivedLatch.await(20000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)this.cache("LON", 0).get((Object)"k"));
        Assert.assertNull((Object)this.cache("LON", 1).get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
        this.blockingInterceptor.waitingLatch.countDown();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return NonTxAsyncBackupTest.this.backup("LON").get((Object)"k") == null;
            }
        });
    }

    public void testReplace() throws Exception {
        this.doPutWithDisabledBlockingInterceptor();
        this.cache("LON", 1).replace((Object)"k", (Object)"v2");
        this.blockingInterceptor.invocationReceivedLatch.await(20000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"v2", (Object)this.cache("LON", 0).get((Object)"k"));
        Assert.assertEquals((Object)"v2", (Object)this.cache("LON", 1).get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
        this.blockingInterceptor.waitingLatch.countDown();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(NonTxAsyncBackupTest.this.backup("LON").get((Object)"k"));
            }
        });
    }

    public void testPutAll() throws Exception {
        this.cache("LON", 0).putAll(Collections.singletonMap("k", "v"));
        this.blockingInterceptor.invocationReceivedLatch.await(20000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"v", (Object)this.cache("LON", 0).get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)this.cache("LON", 1).get((Object)"k"));
        Assert.assertNull((Object)this.backup("LON").get((Object)"k"));
        this.blockingInterceptor.waitingLatch.countDown();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(NonTxAsyncBackupTest.this.backup("LON").get((Object)"k"));
            }
        });
    }

    private void doPutWithDisabledBlockingInterceptor() {
        this.blockingInterceptor.isActive = false;
        this.cache("LON", 0).put((Object)"k", (Object)"v");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(NonTxAsyncBackupTest.this.backup("LON").get((Object)"k"));
            }
        });
        this.blockingInterceptor.isActive = true;
    }

    public static class BlockingInterceptor
    extends CommandInterceptor {
        public volatile CountDownLatch invocationReceivedLatch = new CountDownLatch(1);
        public volatile CountDownLatch waitingLatch = new CountDownLatch(1);
        public volatile boolean isActive = true;

        void reset() {
            this.invocationReceivedLatch = new CountDownLatch(1);
            this.waitingLatch = new CountDownLatch(1);
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            return this.handle((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            return this.handle(ctx, (VisitableCommand)command);
        }

        protected Object handle(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (this.isActive) {
                this.invocationReceivedLatch.countDown();
                this.waitingLatch.await();
            }
            return super.handleDefault(ctx, command);
        }
    }
}

