/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.xsite.CountingCustomFailurePolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsingTest")
public class XSiteFileParsingTest
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-test.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml(FILE_NAME);
        return embeddedCacheManager;
    }

    public void testGlobalConfiguration() {
        GlobalConfiguration cmc = this.cacheManager.getCacheManagerConfiguration();
        AssertJUnit.assertEquals((String)"LON", (String)cmc.sites().localSite());
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        this.testDefault(dcc);
    }

    public void testBackupNyc() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("backupNyc");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)0);
        BackupForConfiguration backupForConfiguration = dcc.sites().backupFor();
        AssertJUnit.assertEquals((String)"someCache", (String)backupForConfiguration.remoteCache());
        AssertJUnit.assertEquals((String)"NYC", (String)backupForConfiguration.remoteSite());
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoBackups() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackups");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)0);
        AssertJUnit.assertEquals((String)dcc.sites().backupFor().remoteCache(), null);
        AssertJUnit.assertEquals((String)dcc.sites().backupFor().remoteSite(), null);
    }

    public void testCustomBackupPolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("customBackupPolicy");
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("NYC2", BackupConfiguration.BackupStrategy.SYNC, 160000L, BackupFailurePolicy.CUSTOM, CountingCustomFailurePolicy.class.getName(), false, new TakeOfflineConfiguration(0, 0L), true)));
        AssertJUnit.assertEquals((String)dcc.sites().backupFor().remoteCache(), null);
    }

    private void testDefault(Configuration dcc) {
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)2);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("NYC", BackupConfiguration.BackupStrategy.SYNC, 12003L, BackupFailurePolicy.IGNORE, null, false, new TakeOfflineConfiguration(0, 0L), true)));
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("SFO", BackupConfiguration.BackupStrategy.ASYNC, 10000L, BackupFailurePolicy.WARN, null, false, new TakeOfflineConfiguration(0, 0L), true)));
    }
}

