/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.backupfailure;

import java.util.HashMap;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.xsite.backupfailure.BaseBackupFailureTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.backupfailure.NonTxBackupFailureTest")
public class NonTxBackupFailureTest
extends BaseBackupFailureTest {
    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return NonTxBackupFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return NonTxBackupFailureTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }

    public void testPutFailure() {
        try {
            this.cache("LON", 0).put((Object)"k", (Object)"v");
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON", 1).get((Object)"k"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.putFailed);
        AssertJUnit.assertNull((Object)this.backup("LON").get((Object)"k"));
    }

    public void testRemoveFailure() {
        this.failureInterceptor.disable();
        this.cache("LON", 0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
        this.failureInterceptor.enable();
        try {
            this.cache("LON", 0).remove((Object)"k");
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        AssertJUnit.assertNull((Object)this.cache("LON", 0).get((Object)"k"));
        AssertJUnit.assertNull((Object)this.cache("LON", 1).get((Object)"k"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.removeFailed);
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
    }

    public void testReplaceFailure() {
        this.failureInterceptor.disable();
        this.cache("LON", 0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache("LON", 1).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
        this.failureInterceptor.enable();
        try {
            this.cache("LON", 0).replace((Object)"k", (Object)"v2");
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache("LON", 0).get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache("LON", 1).get((Object)"k"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.replaceFailed);
        AssertJUnit.assertEquals((Object)"v", (Object)this.backup("LON").get((Object)"k"));
    }

    public void testClearFailure() {
        this.failureInterceptor.disable();
        this.cache("LON", 0).put((Object)"k1", (Object)"v1");
        this.cache("LON", 0).put((Object)"k2", (Object)"v2");
        this.cache("LON", 0).put((Object)"k3", (Object)"v3");
        this.failureInterceptor.enable();
        try {
            this.cache("LON", 1).clear();
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        AssertJUnit.assertNull((Object)this.cache("LON", 0).get((Object)"k1"));
        AssertJUnit.assertNull((Object)this.cache("LON", 0).get((Object)"k2"));
        AssertJUnit.assertNull((Object)this.cache("LON", 1).get((Object)"k3"));
        AssertJUnit.assertTrue((boolean)this.failureInterceptor.clearFailed);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.backup("LON").get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.backup("LON").get((Object)"k2"));
        AssertJUnit.assertEquals((Object)"v3", (Object)this.backup("LON").get((Object)"k3"));
    }

    public void testPutMapFailure() {
        HashMap<String, String> toAdd = new HashMap<String, String>();
        for (int i = 0; i < 100; ++i) {
            toAdd.put("k" + i, "v" + i);
        }
        try {
            this.cache("LON", 0).putAll(toAdd);
            this.checkFailOnBackupFailure();
        }
        catch (CacheException e) {
            this.checkNonFailOnBackupFailure();
        }
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertEquals((Object)("v" + i), (Object)this.cache("LON", i % 2).get((Object)("k" + i)));
            AssertJUnit.assertNull((Object)this.backup("LON").get((Object)("k" + i)));
        }
    }

    private void checkNonFailOnBackupFailure() {
        if (!this.failOnBackupFailure("LON", 0)) {
            throw new AssertionError((Object)"Should fail silently!");
        }
    }

    private void checkFailOnBackupFailure() {
        if (this.failOnBackupFailure("LON", 0)) {
            throw new AssertionError((Object)"Exception expected!");
        }
    }
}

