/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.xsite.OfflineStatus;
import org.testng.annotations.Test;

@Test(groups={"xsite, functional"}, testName="xsite.offline.OfflineStatusTest")
public class OfflineStatusTest
extends AbstractInfinispanTest {
    public void timeBasedTakeOffline() {
        final OfflineStatus offlineStatus = new OfflineStatus(new TakeOfflineConfiguration(10, 3000L));
        assert (!offlineStatus.isOffline());
        for (int i = 0; i < 9; ++i) {
            offlineStatus.updateOnCommunicationFailure(this.now());
        }
        Assert.assertEquals((int)9, (int)offlineStatus.getFailureCount());
        assert (!offlineStatus.isOffline());
        assert (!offlineStatus.minTimeHasElapsed()) : offlineStatus.millisSinceFirstFailure();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                Thread.sleep(1000L);
                return offlineStatus.minTimeHasElapsed();
            }
        });
        Assert.assertEquals((int)9, (int)offlineStatus.getFailureCount());
        assert (!offlineStatus.isOffline());
        assert (offlineStatus.minTimeHasElapsed());
        offlineStatus.updateOnCommunicationFailure(this.now());
        Assert.assertEquals((int)10, (int)offlineStatus.getFailureCount());
        assert (offlineStatus.isOffline());
        assert (offlineStatus.minTimeHasElapsed());
    }

    public void testFailureBasedOnly() throws Throwable {
        OfflineStatus offlineStatus = new OfflineStatus(new TakeOfflineConfiguration(10, 0L));
        this.test(offlineStatus);
        offlineStatus.reset();
        this.test(offlineStatus);
    }

    private void test(OfflineStatus offlineStatus) throws InterruptedException {
        for (int i = 0; i < 9; ++i) {
            offlineStatus.updateOnCommunicationFailure(this.now());
        }
        assert (!offlineStatus.isOffline());
        Thread.sleep(2000L);
        assert (!offlineStatus.isOffline());
        offlineStatus.updateOnCommunicationFailure(this.now());
        Assert.assertEquals((int)10, (int)offlineStatus.getFailureCount());
        assert (offlineStatus.isOffline());
    }

    private long now() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }
}

