/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.BackupSenderImpl;
import org.infinispan.xsite.BaseSiteUnreachableTest;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.offline.DelegatingTransport;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.ResetOfflineStatusTest")
public class ResetOfflineStatusTest
extends BaseSiteUnreachableTest {
    private static final int FAILURES = 8;

    public ResetOfflineStatusTest() {
        this.failures = 8;
        this.lonBackupFailurePolicy = BackupFailurePolicy.FAIL;
    }

    public void testPutWithFailures() {
        int i;
        ComponentRegistry registry = this.cache("LON", 0).getAdvancedCache().getComponentRegistry();
        Transport transport = (Transport)registry.getComponent(Transport.class);
        DelegatingTransport delegatingTransport = new DelegatingTransport(transport);
        registry.getGlobalComponentRegistry().registerComponent((Object)delegatingTransport, Transport.class);
        BackupSenderImpl bs = (BackupSenderImpl)registry.getComponent(BackupSender.class);
        registry.rewire();
        OfflineStatus offlineStatus = bs.getOfflineStatus("NYC");
        delegatingTransport.fail = true;
        for (i = 0; i < 8; ++i) {
            try {
                this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
                Assert.fail((String)"This should have failed");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < 8; ++i) {
            this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 8; ++i) {
            junit.framework.Assert.assertEquals((Object)("v" + i), (Object)this.cache("LON", 0).get((Object)("k" + i)));
        }
        junit.framework.Assert.assertEquals((Object)BackupSender.BringSiteOnlineResponse.BROUGHT_ONLINE, (Object)bs.bringSiteOnline("NYC"));
        for (i = 0; i < 7; ++i) {
            try {
                this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
                Assert.fail((String)"This should have failed");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        delegatingTransport.fail = false;
        junit.framework.Assert.assertEquals((int)7, (int)offlineStatus.getFailureCount());
        this.cache("LON", 0).put((Object)"ki", (Object)"vi");
        junit.framework.Assert.assertEquals((int)0, (int)offlineStatus.getFailureCount());
        for (i = 0; i < 80; ++i) {
            this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 80; ++i) {
            junit.framework.Assert.assertEquals((Object)("v" + i), (Object)this.cache("LON", 0).get((Object)("k" + i)));
        }
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return ResetOfflineStatusTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }
}

