/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.util.HashMap;
import javax.jcr.Credentials;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.jcr.JcrRepository;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.cmis.JcrService;

public class JcrServiceTest {
    @Test
    public void testWorkspace() {
        String[] names = new String[]{"foo", "", "baz", "a"};
        JcrRepository mockRepo = (JcrRepository)Mockito.mock(JcrRepository.class);
        HashMap<String, JcrRepository> jrs = new HashMap<String, JcrRepository>();
        for (String name : names) {
            jrs.put(name, mockRepo);
        }
        JcrService js = new JcrService(jrs);
        js.setCallContext((CallContext)Mockito.mock(CallContext.class));
        js.login("foo");
        ((JcrRepository)Mockito.verify((Object)mockRepo)).login(null, null);
        js.login("foo:");
        ((JcrRepository)Mockito.verify((Object)mockRepo, (VerificationMode)Mockito.times((int)2))).login(null, null);
        js.login("foo:bar");
        ((JcrRepository)Mockito.verify((Object)mockRepo)).login((Credentials)Matchers.any(Credentials.class), (String)Matchers.eq((Object)"bar"));
        js.login(":quux");
        ((JcrRepository)Mockito.verify((Object)mockRepo)).login((Credentials)Matchers.any(Credentials.class), (String)Matchers.eq((Object)"quux"));
        js.login("a:b:c");
        ((JcrRepository)Mockito.verify((Object)mockRepo)).login((Credentials)Matchers.any(Credentials.class), (String)Matchers.eq((Object)"b"));
    }
}

