/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersion;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.modeshape.cmis.JcrMsVersionNode;
import org.modeshape.jcr.api.Binary;

public class JcrMsVersion
extends JcrVersion {
    private static final String HASH_ALGORITHM = "sha-1";

    public JcrMsVersion(Node node, Version version, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, version, typeManager, pathManager, typeHandlerManager);
    }

    public Iterator<JcrVersion> getVersions() {
        try {
            VersionHistory versionHistory = JcrMsVersion.getVersionHistory((Node)this.getNode());
            final VersionIterator versions = versionHistory.getAllLinearVersions();
            return new Iterator<JcrVersion>(){

                @Override
                public boolean hasNext() {
                    return versions.hasNext();
                }

                @Override
                public JcrVersion next() {
                    return new JcrMsVersionNode(JcrMsVersion.this.getNode(), versions.nextVersion(), JcrMsVersion.this.typeManager, JcrMsVersion.this.pathManager, JcrMsVersion.this.typeHandlerManager);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (RepositoryException e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrVersion getVersion(String name) {
        try {
            Node node = this.getNode();
            VersionHistory versionHistory = JcrMsVersion.getVersionHistory((Node)node);
            Version version = versionHistory.getVersion(name);
            return new JcrMsVersion(node, version, this.typeManager, this.pathManager, this.typeHandlerManager);
        }
        catch (UnsupportedRepositoryOperationException | VersionException e) {
            throw new CmisObjectNotFoundException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected void compileProperties(PropertiesImpl properties, Set<String> filter, ObjectInfoImpl objectInfo) throws RepositoryException {
        super.compileProperties(properties, filter, objectInfo);
        this.addPropertyString(properties, this.getTypeIdInternal(), filter, "cmis:contentStreamHash", this.getHash());
    }

    private String getHash() {
        try {
            Node contentNode = this.getContextNode();
            Property data = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data");
            Binary bin = (Binary)data.getBinary();
            return String.format("{%s}%s", HASH_ALGORITHM, bin.getHexHash());
        }
        catch (RepositoryException e) {
            return "";
        }
    }
}

