/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.jcr.JcrRepository;
import org.apache.chemistry.opencmis.server.support.wrapper.CallContextAwareCmisService;
import org.modeshape.cmis.RepositoryInfoLocal;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.web.jcr.WebLogger;

public class JcrService
extends AbstractCmisService
implements CallContextAwareCmisService {
    private static final Logger LOGGER = WebLogger.getLogger(JcrService.class);
    private final Map<String, JcrRepository> jcrRepositories;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private CallContext context;

    public JcrService(Map<String, JcrRepository> jcrRepositories) {
        this.jcrRepositories = jcrRepositories;
    }

    public void close() {
        for (Session session : this.sessions.values()) {
            session.logout();
        }
        super.close();
    }

    public void setCallContext(CallContext context) {
        this.context = context;
    }

    public CallContext getCallContext() {
        return this.context;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        LOGGER.debug("-- getting repository info", new Object[0]);
        RepositoryInfo info = this.jcrRepository(repositoryId).getRepositoryInfo(this.login(repositoryId));
        return new RepositoryInfoLocal(repositoryId, info);
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        ArrayList<RepositoryInfo> info = new ArrayList<RepositoryInfo>();
        Set<String> IDs = this.jcrRepositories.keySet();
        for (String Id : IDs) {
            JcrRepository repo = this.jcrRepositories.get(Id);
            List infos = repo.getRepositoryInfos(this.login(Id));
            for (RepositoryInfo i : infos) {
                info.add((RepositoryInfo)new RepositoryInfoLocal(Id, i));
            }
        }
        return info;
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getTypeChildren(this.login(repositoryId), typeId, includePropertyDefinitions.booleanValue(), maxItems, skipCount);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getTypeDefinition(this.login(repositoryId), typeId);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getTypesDescendants(this.login(repositoryId), typeId, depth, includePropertyDefinitions);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getChildren(this.login(repositoryId), folderId, filter, includeAllowableActions, includePathSegment, maxItems, skipCount, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getDescendants(this.login(repositoryId), folderId, depth, filter, includeAllowableActions, includePathSegment, (ObjectInfoHandler)this, this.context.isObjectInfoRequired(), false);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getFolderParent(this.login(repositoryId), folderId, filter, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getDescendants(this.login(repositoryId), folderId, depth, filter, includeAllowableActions, includePathSegment, (ObjectInfoHandler)this, this.context.isObjectInfoRequired(), true);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getObjectParents(this.login(repositoryId), objectId, filter, includeAllowableActions, includeRelativePathSegment, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getCheckedOutDocs(this.login(repositoryId), folderId, filter, orderBy, includeAllowableActions, maxItems, skipCount);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).createDocument(this.login(repositoryId), properties, folderId, contentStream, versioningState);
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).createDocumentFromSource(this.login(repositoryId), sourceId, properties, folderId, versioningState);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.jcrRepository(repositoryId).setContentStream(this.login(repositoryId), objectId, overwriteFlag, contentStream);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.jcrRepository(repositoryId).setContentStream(this.login(repositoryId), objectId, Boolean.valueOf(true), null);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).createFolder(this.login(repositoryId), properties, folderId);
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.jcrRepository(repositoryId).deleteObject(this.login(repositoryId), objectId, allVersions);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).deleteTree(this.login(repositoryId), folderId);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getAllowableActions(this.login(repositoryId), objectId);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getContentStream(this.login(repositoryId), objectId, offset, length);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getObject(this.login(repositoryId), objectId, filter, includeAllowableActions, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getObjectByPath(this.login(repositoryId), path, filter, includeAllowableActions.booleanValue(), includeAcl.booleanValue(), (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getProperties(this.login(repositoryId), objectId, filter, Boolean.valueOf(false), (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.jcrRepository(repositoryId).moveObject(this.login(repositoryId), objectId, targetFolderId, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.jcrRepository(repositoryId).updateProperties(this.login(repositoryId), objectId, properties, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.jcrRepository(repositoryId).checkOut(this.login(repositoryId), objectId, contentCopied);
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.jcrRepository(repositoryId).cancelCheckout(this.login(repositoryId), objectId);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.jcrRepository(repositoryId).checkIn(this.login(repositoryId), objectId, major, properties, contentStream, checkinComment);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getAllVersions(this.login(repositoryId), versionSeriesId == null ? objectId : versionSeriesId, filter, includeAllowableActions, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).getObject(this.login(repositoryId), versionSeriesId == null ? objectId : versionSeriesId, filter, includeAllowableActions, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        ObjectData object = this.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, false, null, null, false, false, extension);
        return object.getProperties();
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository(repositoryId).query(this.login(repositoryId), statement, searchAllVersions, includeAllowableActions, maxItems, skipCount);
    }

    protected Session login(String repositoryId) {
        LOGGER.debug("--- login: " + repositoryId, new Object[0]);
        if (this.context == null) {
            throw new CmisRuntimeException("No user context!");
        }
        Session session = this.sessions.get(repositoryId);
        if (session == null) {
            HttpServletRequest request = (HttpServletRequest)this.context.get("httpServletRequest");
            if (request != null) {
                try {
                    session = this.jcrRepository(repositoryId).login((Credentials)new ServletCredentials(request), this.workspace(repositoryId));
                    this.sessions.put(repositoryId, session);
                    return session;
                }
                catch (CmisPermissionDeniedException e) {
                    LOGGER.debug((Throwable)e, "Cannot authenticate using http authentication", new Object[0]);
                }
            }
            String userName = this.context.getUsername();
            String password = this.context.getPassword();
            SimpleCredentials credentials = userName == null ? null : new SimpleCredentials(userName, password == null ? "".toCharArray() : password.toCharArray());
            try {
                session = this.jcrRepository(repositoryId).login((Credentials)credentials, this.workspace(repositoryId));
                this.sessions.put(repositoryId, session);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return session;
    }

    private JcrRepository jcrRepository(String repositoryId) {
        String name = this.name(repositoryId);
        JcrRepository repo = this.jcrRepositories.get(name);
        if (repo == null) {
            throw new CmisInvalidArgumentException("Repository lookup failed for \"" + repositoryId + "\" (using name \"" + name + "\")");
        }
        return repo;
    }

    private String name(String repositoryId) {
        CheckArg.isNotNull((Object)repositoryId, (String)"repositoryId");
        repositoryId = repositoryId.trim();
        String[] parts = repositoryId.split(":", 2);
        int numParts = parts.length;
        if (numParts > 1) {
            return parts[0].trim();
        }
        return repositoryId;
    }

    private String workspace(String repositoryId) {
        CheckArg.isNotNull((Object)repositoryId, (String)"repositoryId");
        repositoryId = repositoryId.trim();
        String[] parts = repositoryId.split(":");
        int numParts = parts.length;
        if (numParts > 1) {
            return parts[1].trim();
        }
        return null;
    }
}

