/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class JcrPermission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private ArrayList<JcrPermission> aggregates = new ArrayList();
    public static final JcrPermission LIFECYCLE_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}lifecycleManagement", "Life cycle management");
    public static final JcrPermission LOCK_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}lockManagement", "Lock management");
    public static final JcrPermission NODE_TYPE_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}nodeTypeManagement", "Node type management");
    public static final JcrPermission RETENTION_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}retentionManagement", "Retention management");
    public static final JcrPermission VERSION_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}versionManagement", "Version management");
    public static final JcrPermission READ_ACCESS_CONTROL = new JcrPermission("{http://www.jcp.org/jcr/1.0}readAccessControl", "Read access control");
    public static final JcrPermission MODIFY_ACCESS_CONTROL = new JcrPermission("{http://www.jcp.org/jcr/1.0}modifyAccessControl", "Modify access control");
    public static final JcrPermission READ = new JcrPermission("{http://www.jcp.org/jcr/1.0}read", "Read");
    public static final JcrPermission ADD_CHILD_NODES = new JcrPermission("{http://www.jcp.org/jcr/1.0}addChildNodes", "Add child nodes");
    public static final JcrPermission REMOVE_CHILD_NODES = new JcrPermission("{http://www.jcp.org/jcr/1.0}removeChildNodes", "Remove child nodes");
    public static final JcrPermission MODIFY_PROPERTIES = new JcrPermission("{http://www.jcp.org/jcr/1.0}modifyProperties", "Modify properties");
    public static final JcrPermission WRITE = new JcrPermission("{http://www.jcp.org/jcr/1.0}write", "Write", new JcrPermission[]{ADD_CHILD_NODES, REMOVE_CHILD_NODES, MODIFY_PROPERTIES});
    public static final JcrPermission ALL = new JcrPermission("{http://www.jcp.org/jcr/1.0}all", "All permissions", new JcrPermission[]{LIFECYCLE_MANAGEMENT, LOCK_MANAGEMENT, NODE_TYPE_MANAGEMENT, RETENTION_MANAGEMENT, VERSION_MANAGEMENT, READ_ACCESS_CONTROL, MODIFY_ACCESS_CONTROL, READ, WRITE});
    private static JcrPermission[] PERMISSIONS = new JcrPermission[]{ALL, LIFECYCLE_MANAGEMENT, LOCK_MANAGEMENT, NODE_TYPE_MANAGEMENT, RETENTION_MANAGEMENT, VERSION_MANAGEMENT, READ_ACCESS_CONTROL, MODIFY_ACCESS_CONTROL, READ, WRITE, ADD_CHILD_NODES, MODIFY_PROPERTIES, REMOVE_CHILD_NODES};

    public static JcrPermission fromDisplayName(String name) {
        for (int i = 0; i < PERMISSIONS.length; ++i) {
            if (!PERMISSIONS[i].getDisplayName().equals(name)) continue;
            return PERMISSIONS[i];
        }
        return null;
    }

    public JcrPermission() {
    }

    public JcrPermission(String name) {
        this.name = name;
    }

    public JcrPermission(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public JcrPermission(String name, String displayName, JcrPermission ... aggregates) {
        this.name = name;
        this.displayName = displayName;
        this.aggregates.addAll(Arrays.asList(aggregates));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean matches(JcrPermission permission) {
        if (this.name.equals(permission.name)) {
            return true;
        }
        for (JcrPermission p : this.aggregates) {
            if (!p.matches(permission)) continue;
            return true;
        }
        return false;
    }
}

