/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.domain.IModeShapeObject;
import org.modeshape.web.jcr.rest.client.domain.Server;

@Immutable
public class Repository
implements IModeShapeObject {
    private final String name;
    private final Server server;

    public Repository(String name, Server server) {
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)server, (String)"server");
        this.name = name;
        this.server = server;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Repository otherRepository = (Repository)obj;
        return this.name.equals(otherRepository.name) && this.server.equals(otherRepository.server);
    }

    public String getName() {
        return this.name;
    }

    public Server getServer() {
        return this.server;
    }

    public String getShortDescription() {
        return RestClientI18n.repositoryShortDescription.text(new Object[]{this.name, this.server.getName()});
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.name, this.server});
    }

    public String toString() {
        return this.getShortDescription();
    }
}

