/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Workspace;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;
import org.modeshape.web.jcr.rest.client.json.ServerNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryNode
extends JsonNode {
    private final Repository repository;

    public RepositoryNode(Repository repository) {
        super(repository.getName());
        this.repository = repository;
    }

    @Override
    public URL getUrl() throws Exception {
        ServerNode serverNode = new ServerNode(this.repository.getServer());
        StringBuilder url = new StringBuilder(serverNode.getUrl().toString());
        url.append('/').append(JsonUtils.encode(this.repository.getName()));
        return new URL(url.toString());
    }

    public Collection<Workspace> getWorkspaces(String jsonResponse) throws Exception {
        CheckArg.isNotNull((Object)jsonResponse, (String)"jsonResponse");
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        JSONObject jsonObj = new JSONObject(jsonResponse);
        Iterator itr = jsonObj.keys();
        while (itr.hasNext()) {
            String name = JsonUtils.decode((String)itr.next());
            Workspace workspace = new Workspace(name, this.repository);
            workspaces.add(workspace);
        }
        return workspaces;
    }
}

